/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.exception;

import com.tugos.dst.admin.common.ResultCodeEnum;
import com.tugos.dst.admin.common.ResultVO;
import com.tugos.dst.admin.exception.ResultException;
import com.tugos.dst.admin.utils.SafeLoginCheckUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.ShiroException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={ShiroException.class})
    public ResultVO<String> authorizationException(ShiroException exception) {
        log.error("ShiroException\u5f02\u5e38\uff1a", (Throwable)exception);
        return ResultVO.fail((ResultCodeEnum)ResultCodeEnum.NO_PERMISSIONS);
    }

    @ExceptionHandler(value={IncorrectCredentialsException.class})
    @ResponseBody
    public ResultVO<String> handleIncorrectCredentialsException(HttpServletRequest request, IncorrectCredentialsException e) {
        log.error("shiro \u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff1a{}", (Object)e.getMessage());
        SafeLoginCheckUtils.loginErrorRecord((HttpServletRequest)request);
        return ResultVO.fail((String)String.format(ResultCodeEnum.NOT_EXIST_USER_OR_ERROR_PWD.getMessage(), SafeLoginCheckUtils.getRemainingTimes((HttpServletRequest)request)));
    }

    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResultVO<String> handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        log.error("405\u5f02\u5e38", (Throwable)e);
        return ResultVO.fail((ResultCodeEnum)ResultCodeEnum.METHOD_NOT_ALLOWED);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResultVO<Map<String, String>> handleValidationExceptions(MethodArgumentNotValidException ex) {
        HashMap errors = new HashMap(16);
        ex.getBindingResult().getAllErrors().forEach(error -> {
            String fieldName = ((FieldError)error).getField();
            String errorMessage = error.getDefaultMessage();
            errors.put(fieldName, errorMessage);
        });
        ResultVO fail = ResultVO.fail((ResultCodeEnum)ResultCodeEnum.PARAM_ERR);
        fail.setData(errors);
        return fail;
    }

    @ExceptionHandler(value={ResultException.class})
    public ResultVO<String> resultException(ResultException e) {
        return ResultVO.fail((int)e.getCode(), (String)e.getMessage());
    }
}

