/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.controller;

import com.tugos.dst.admin.common.ResultCodeEnum;
import com.tugos.dst.admin.common.ResultVO;
import com.tugos.dst.admin.config.I18nResourcesConfig;
import com.tugos.dst.admin.exception.ResultException;
import com.tugos.dst.admin.utils.SafeLoginCheckUtils;
import com.tugos.dst.admin.utils.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LoginController {
    @GetMapping(value={"/login"})
    public String toLogin() {
        return "login";
    }

    @PostMapping(value={"/login"})
    @ResponseBody
    public ResultVO<URL> login(HttpServletRequest request, String username, String password) {
        if (StringUtils.isEmpty((CharSequence)username) || StringUtils.isEmpty((CharSequence)password)) {
            throw new ResultException(ResultCodeEnum.USER_NAME_PWD_NULL);
        }
        if (!SafeLoginCheckUtils.isAllowLogin((HttpServletRequest)request)) {
            throw new ResultException(ResultCodeEnum.USER_HAS_FREEZE);
        }
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(username, password);
        subject.login((AuthenticationToken)token);
        SafeLoginCheckUtils.cleanErrorRecord((HttpServletRequest)request);
        ResultVO data = ResultVO.data((Object)new URL("/"));
        int weakPsw = 6;
        if (StringUtils.isNotBlank((CharSequence)password) && password.length() <= weakPsw) {
            data.setMessage(I18nResourcesConfig.getMessage((String)"tip.login.success.psw.weak"));
        } else {
            data.setMessage(I18nResourcesConfig.getMessage((String)"tip.login.success"));
        }
        return data;
    }

    @GetMapping(value={"/logout"})
    public String logout() {
        SecurityUtils.getSubject().logout();
        return "redirect:/login";
    }

    @GetMapping(value={"/noAuth"})
    public String noAuth() {
        return "system/main/noAuth";
    }
}

