/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.config;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.i18n.LocaleContextHolder;

@PropertySource(value={"classpath:i18n/messages*.properties"})
public class I18nResourcesConfig {
    private static final Map<String, ResourceBundle> MESSAGES = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessage(String key) {
        Locale locale = LocaleContextHolder.getLocale();
        ResourceBundle message = (ResourceBundle)MESSAGES.get(locale.getLanguage());
        if (message == null) {
            Map map = MESSAGES;
            synchronized (map) {
                message = (ResourceBundle)MESSAGES.get(locale.getLanguage());
                if (message == null) {
                    message = ResourceBundle.getBundle("i18n/messages", locale);
                    MESSAGES.put(locale.getLanguage(), message);
                }
            }
        }
        return message.getString(key);
    }

    public static void flushMessage() {
        MESSAGES.clear();
    }
}

