/*
 * Decompiled with CFR 0.152.
 */
package pl.pzienowicz.autoscrollviewpager;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.Interpolator;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.pzienowicz.autoscrollviewpager.CustomDurationScroller;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0003567B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001e\u001a\u00020\u000bJ\u0006\u0010\u001f\u001a\u00020\u000fJ\u0006\u0010 \u001a\u00020\u001bJ\u0006\u0010\u0012\u001a\u00020\u0011J\u0006\u0010\u0013\u001a\u00020\u0011J\u0006\u0010!\u001a\u00020\u0011J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0016J\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u000fH\u0002J\u000e\u0010)\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010*\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u0011J\u000e\u0010+\u001a\u00020&2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010,\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u00101\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u0011J\b\u00102\u001a\u00020&H\u0002J\u0006\u00103\u001a\u00020&J\u000e\u00103\u001a\u00020&2\u0006\u0010(\u001a\u00020\tJ\u0006\u00104\u001a\u00020&R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lpl/pzienowicz/autoscrollviewpager/AutoScrollViewPager;", "Landroidx/viewpager/widget/ViewPager;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defaultInterval", "", "direction", "Lpl/pzienowicz/autoscrollviewpager/AutoScrollViewPager$Direction;", "downX", "", "interval", "", "isAutoScroll", "", "isBorderAnimation", "isCycle", "isStopByTouch", "myHandler", "Landroid/os/Handler;", "scrollWhat", "scroller", "Lpl/pzienowicz/autoscrollviewpager/CustomDurationScroller;", "slideBorderMode", "Lpl/pzienowicz/autoscrollviewpager/AutoScrollViewPager$SlideBorderMode;", "stopScrollWhenTouch", "touchX", "getDirection", "getInterval", "getSlideBorderMode", "isStopScrollWhenTouch", "onTouchEvent", "ev", "Landroid/view/MotionEvent;", "scrollOnce", "", "sendScrollMessage", "delayTimeInMills", "setBorderAnimation", "setCycle", "setDirection", "setInterval", "setScrollDurationFactor", "scrollFactor", "", "setSlideBorderMode", "setStopScrollWhenTouch", "setViewPagerScroller", "startAutoScroll", "stopAutoScroll", "Direction", "MyHandler", "SlideBorderMode", "autoscrollviewpager_release"})
public final class AutoScrollViewPager
extends ViewPager {
    private final int defaultInterval;
    private final int scrollWhat;
    private long interval;
    @NotNull
    private Direction direction;
    private boolean isCycle;
    private boolean stopScrollWhenTouch;
    @NotNull
    private SlideBorderMode slideBorderMode;
    private boolean isBorderAnimation;
    private boolean isAutoScroll;
    private boolean isStopByTouch;
    private float touchX;
    private float downX;
    @Nullable
    private CustomDurationScroller scroller;
    @NotNull
    private Handler myHandler;

    public AutoScrollViewPager(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.defaultInterval = 1500;
        this.interval = this.defaultInterval;
        this.direction = Direction.RIGHT;
        this.isCycle = true;
        this.stopScrollWhenTouch = true;
        this.slideBorderMode = SlideBorderMode.NONE;
        this.isBorderAnimation = true;
        this.myHandler = new MyHandler();
        this.setViewPagerScroller();
    }

    public AutoScrollViewPager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null);
    }

    public final void startAutoScroll() {
        this.isAutoScroll = true;
        this.sendScrollMessage(this.interval);
    }

    public final void startAutoScroll(int delayTimeInMills) {
        this.isAutoScroll = true;
        this.sendScrollMessage(delayTimeInMills);
    }

    public final void stopAutoScroll() {
        this.isAutoScroll = false;
        this.myHandler.removeMessages(this.scrollWhat);
    }

    public final void setScrollDurationFactor(double scrollFactor) {
        CustomDurationScroller customDurationScroller = this.scroller;
        if (customDurationScroller != null) {
            customDurationScroller.setScrollDurationFactor(scrollFactor);
        }
    }

    private final void sendScrollMessage(long delayTimeInMills) {
        this.myHandler.removeMessages(this.scrollWhat);
        this.myHandler.sendEmptyMessageDelayed(this.scrollWhat, delayTimeInMills);
    }

    private final void setViewPagerScroller() {
        try {
            Field scrollerField = ViewPager.class.getDeclaredField("mScroller");
            scrollerField.setAccessible(true);
            Field interpolatorField = ViewPager.class.getDeclaredField("sInterpolator");
            interpolatorField.setAccessible(true);
            Object object = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context");
            Context context = object;
            object = interpolatorField.get(null);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.animation.Interpolator");
            }
            this.scroller = new CustomDurationScroller(context, (Interpolator)object);
            scrollerField.set((Object)this, (Object)this.scroller);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void scrollOnce() {
        int nextItem;
        block11: {
            block10: {
                if (this.getAdapter() == null) break block10;
                PagerAdapter pagerAdapter = this.getAdapter();
                Intrinsics.checkNotNull((Object)pagerAdapter);
                if (pagerAdapter.getCount() > 1) break block11;
            }
            return;
        }
        int currentItem = this.getCurrentItem();
        PagerAdapter pagerAdapter = this.getAdapter();
        Intrinsics.checkNotNull((Object)pagerAdapter);
        int totalCount = pagerAdapter.getCount();
        int n = nextItem = this.direction == Direction.LEFT ? --currentItem : ++currentItem;
        if (nextItem < 0) {
            if (this.isCycle) {
                this.setCurrentItem(totalCount - 1, this.isBorderAnimation);
            }
        } else if (nextItem == totalCount) {
            if (this.isCycle) {
                this.setCurrentItem(0, this.isBorderAnimation);
            }
        } else {
            this.setCurrentItem(nextItem, true);
        }
    }

    public boolean onTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        if (this.stopScrollWhenTouch) {
            if (ev.getAction() == 0 && this.isAutoScroll) {
                this.isStopByTouch = true;
                this.stopAutoScroll();
            } else if (ev.getAction() == 1 && this.isStopByTouch) {
                this.startAutoScroll();
            }
        }
        if (this.slideBorderMode == SlideBorderMode.TO_PARENT || this.slideBorderMode == SlideBorderMode.CYCLE) {
            int n;
            int pageCount;
            this.touchX = ev.getX();
            if (ev.getAction() == 0) {
                this.downX = this.touchX;
            }
            int currentItem = this.getCurrentItem();
            PagerAdapter adapter = this.getAdapter();
            PagerAdapter pagerAdapter = adapter;
            int n2 = pageCount = pagerAdapter == null ? 0 : (n = pagerAdapter.getCount());
            if (currentItem == 0 && this.downX <= this.touchX || currentItem == pageCount - 1 && this.downX >= this.touchX) {
                if (this.slideBorderMode == SlideBorderMode.TO_PARENT) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                } else {
                    if (pageCount > 1) {
                        this.setCurrentItem(pageCount - currentItem - 1, this.isBorderAnimation);
                    }
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                return super.onTouchEvent(ev);
            }
        }
        this.getParent().requestDisallowInterceptTouchEvent(true);
        return super.onTouchEvent(ev);
    }

    public final long getInterval() {
        return this.interval;
    }

    public final void setInterval(long interval) {
        this.interval = interval;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    public final void setDirection(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.direction = direction;
    }

    public final boolean isCycle() {
        return this.isCycle;
    }

    public final void setCycle(boolean isCycle) {
        this.isCycle = isCycle;
    }

    public final boolean isStopScrollWhenTouch() {
        return this.stopScrollWhenTouch;
    }

    public final void setStopScrollWhenTouch(boolean stopScrollWhenTouch) {
        this.stopScrollWhenTouch = stopScrollWhenTouch;
    }

    @NotNull
    public final SlideBorderMode getSlideBorderMode() {
        return this.slideBorderMode;
    }

    public final void setSlideBorderMode(@NotNull SlideBorderMode slideBorderMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)slideBorderMode), (String)"slideBorderMode");
        this.slideBorderMode = slideBorderMode;
    }

    public final boolean isBorderAnimation() {
        return this.isBorderAnimation;
    }

    public final void setBorderAnimation(boolean isBorderAnimation) {
        this.isBorderAnimation = isBorderAnimation;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lpl/pzienowicz/autoscrollviewpager/AutoScrollViewPager$Direction;", "", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "autoscrollviewpager_release"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction LEFT = new Direction();
        public static final /* enum */ Direction RIGHT = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value) {
            return Enum.valueOf(Direction.class, value);
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.LEFT, Direction.RIGHT};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lpl/pzienowicz/autoscrollviewpager/AutoScrollViewPager$SlideBorderMode;", "", "(Ljava/lang/String;I)V", "NONE", "CYCLE", "TO_PARENT", "autoscrollviewpager_release"})
    public static final class SlideBorderMode
    extends Enum<SlideBorderMode> {
        public static final /* enum */ SlideBorderMode NONE = new SlideBorderMode();
        public static final /* enum */ SlideBorderMode CYCLE = new SlideBorderMode();
        public static final /* enum */ SlideBorderMode TO_PARENT = new SlideBorderMode();
        private static final /* synthetic */ SlideBorderMode[] $VALUES;

        public static SlideBorderMode[] values() {
            return (SlideBorderMode[])$VALUES.clone();
        }

        public static SlideBorderMode valueOf(String value) {
            return Enum.valueOf(SlideBorderMode.class, value);
        }

        static {
            $VALUES = slideBorderModeArray = new SlideBorderMode[]{SlideBorderMode.NONE, SlideBorderMode.CYCLE, SlideBorderMode.TO_PARENT};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lpl/pzienowicz/autoscrollviewpager/AutoScrollViewPager$MyHandler;", "Landroid/os/Handler;", "(Lpl/pzienowicz/autoscrollviewpager/AutoScrollViewPager;)V", "handleMessage", "", "msg", "Landroid/os/Message;", "autoscrollviewpager_release"})
    private final class MyHandler
    extends Handler {
        public MyHandler() {
            Intrinsics.checkNotNullParameter((Object)((Object)AutoScrollViewPager.this), (String)"this$0");
            super(Looper.getMainLooper());
        }

        public void handleMessage(@NotNull Message msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            super.handleMessage(msg);
            if (msg.what == AutoScrollViewPager.this.scrollWhat) {
                AutoScrollViewPager.this.scrollOnce();
                AutoScrollViewPager.this.sendScrollMessage(AutoScrollViewPager.this.interval);
            }
        }
    }
}

