/*
 * Decompiled with CFR 0.152.
 */
package pl.pzienowicz.autoscrollviewpager;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Interpolator;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import java.lang.reflect.Field;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.pzienowicz.autoscrollviewpager.CustomDurationScroller;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001@B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010)\u001a\u00020\tJ\u0006\u0010*\u001a\u00020\u001cJ\u0006\u0010+\u001a\u00020\tJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020\u001eJ\u0006\u0010,\u001a\u00020\u001eJ\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020/H\u0016J\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u0002012\u0006\u00103\u001a\u00020\u001cH\u0002J\u000e\u00104\u001a\u0002012\u0006\u0010\u001f\u001a\u00020\u001eJ\u000e\u00105\u001a\u0002012\u0006\u0010 \u001a\u00020\u001eJ\u000e\u00106\u001a\u0002012\u0006\u0010\u0018\u001a\u00020\tJ\u000e\u00107\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u00108\u001a\u0002012\u0006\u00109\u001a\u00020:J\u000e\u0010;\u001a\u0002012\u0006\u0010&\u001a\u00020\tJ\u000e\u0010<\u001a\u0002012\u0006\u0010'\u001a\u00020\u001eJ\b\u0010=\u001a\u000201H\u0002J\u0006\u0010>\u001a\u000201J\u000e\u0010>\u001a\u0002012\u0006\u00103\u001a\u00020\tJ\u0006\u0010?\u001a\u000201R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0014\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0014\u0010\u0016\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lpl/pzienowicz/autoscrollviewpager/AutoScrollViewPager;", "Landroidx/viewpager/widget/ViewPager;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "DEFAULT_INTERVAL", "", "getDEFAULT_INTERVAL", "()I", "LEFT", "getLEFT", "RIGHT", "getRIGHT", "SCROLL_WHAT", "getSCROLL_WHAT", "SLIDE_BORDER_MODE_CYCLE", "getSLIDE_BORDER_MODE_CYCLE", "SLIDE_BORDER_MODE_NONE", "getSLIDE_BORDER_MODE_NONE", "SLIDE_BORDER_MODE_TO_PARENT", "getSLIDE_BORDER_MODE_TO_PARENT", "direction", "downX", "", "interval", "", "isAutoScroll", "", "isBorderAnimation", "isCycle", "isStopByTouch", "myHandler", "Landroid/os/Handler;", "scroller", "Lpl/pzienowicz/autoscrollviewpager/CustomDurationScroller;", "slideBorderMode", "stopScrollWhenTouch", "touchX", "getDirection", "getInterval", "getSlideBorderMode", "isStopScrollWhenTouch", "onTouchEvent", "ev", "Landroid/view/MotionEvent;", "scrollOnce", "", "sendScrollMessage", "delayTimeInMills", "setBorderAnimation", "setCycle", "setDirection", "setInterval", "setScrollDurationFactor", "scrollFactor", "", "setSlideBorderMode", "setStopScrollWhenTouch", "setViewPagerScroller", "startAutoScroll", "stopAutoScroll", "MyHandler", "autoscrollviewpager_release"})
public final class AutoScrollViewPager
extends ViewPager {
    private final int DEFAULT_INTERVAL = 1500;
    private final int LEFT = 0;
    private final int RIGHT = 1;
    private final int SLIDE_BORDER_MODE_NONE = 0;
    private final int SLIDE_BORDER_MODE_CYCLE = 1;
    private final int SLIDE_BORDER_MODE_TO_PARENT = 2;
    private long interval;
    private int direction;
    private boolean isCycle;
    private boolean stopScrollWhenTouch;
    private int slideBorderMode;
    private boolean isBorderAnimation;
    private Handler myHandler;
    private boolean isAutoScroll;
    private boolean isStopByTouch;
    private float touchX;
    private float downX;
    private CustomDurationScroller scroller;
    private final int SCROLL_WHAT = 0;
    private HashMap _$_findViewCache;

    public final int getDEFAULT_INTERVAL() {
        return this.DEFAULT_INTERVAL;
    }

    public final int getLEFT() {
        return this.LEFT;
    }

    public final int getRIGHT() {
        return this.RIGHT;
    }

    public final int getSLIDE_BORDER_MODE_NONE() {
        return this.SLIDE_BORDER_MODE_NONE;
    }

    public final int getSLIDE_BORDER_MODE_CYCLE() {
        return this.SLIDE_BORDER_MODE_CYCLE;
    }

    public final int getSLIDE_BORDER_MODE_TO_PARENT() {
        return this.SLIDE_BORDER_MODE_TO_PARENT;
    }

    public final int getSCROLL_WHAT() {
        return this.SCROLL_WHAT;
    }

    public final void startAutoScroll() {
        this.isAutoScroll = true;
        this.sendScrollMessage(this.interval);
    }

    public final void startAutoScroll(int delayTimeInMills) {
        this.isAutoScroll = true;
        this.sendScrollMessage(delayTimeInMills);
    }

    public final void stopAutoScroll() {
        this.isAutoScroll = false;
        this.myHandler.removeMessages(this.SCROLL_WHAT);
    }

    public final void setScrollDurationFactor(double scrollFactor) {
        block0: {
            CustomDurationScroller customDurationScroller = this.scroller;
            if (customDurationScroller == null) break block0;
            customDurationScroller.setScrollDurationFactor(scrollFactor);
        }
    }

    private final void sendScrollMessage(long delayTimeInMills) {
        this.myHandler.removeMessages(this.SCROLL_WHAT);
        this.myHandler.sendEmptyMessageDelayed(this.SCROLL_WHAT, delayTimeInMills);
    }

    private final void setViewPagerScroller() {
        try {
            Field field = ViewPager.class.getDeclaredField("mScroller");
            Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"ViewPager::class.java.ge\u2026eclaredField(\"mScroller\")");
            Field scrollerField = field;
            scrollerField.setAccessible(true);
            Field field2 = ViewPager.class.getDeclaredField("sInterpolator");
            Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"ViewPager::class.java.ge\u2026redField(\"sInterpolator\")");
            Field interpolatorField = field2;
            interpolatorField.setAccessible(true);
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            Object object = interpolatorField.get(null);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.animation.Interpolator");
            }
            this.scroller = new CustomDurationScroller(context, (Interpolator)object);
            scrollerField.set((Object)this, (Object)this.scroller);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void scrollOnce() {
        int nextItem;
        block13: {
            block12: {
                if (this.getAdapter() == null) break block12;
                PagerAdapter pagerAdapter = this.getAdapter();
                if (pagerAdapter == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)pagerAdapter, (String)"adapter!!");
                if (pagerAdapter.getCount() > 1) break block13;
            }
            return;
        }
        int currentItem = this.getCurrentItem();
        PagerAdapter pagerAdapter = this.getAdapter();
        if (pagerAdapter == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)pagerAdapter, (String)"adapter!!");
        int totalCount = pagerAdapter.getCount();
        int n = nextItem = this.direction == this.LEFT ? --currentItem : ++currentItem;
        if (nextItem < 0) {
            if (this.isCycle) {
                this.setCurrentItem(totalCount - 1, this.isBorderAnimation);
            }
        } else if (nextItem == totalCount) {
            if (this.isCycle) {
                this.setCurrentItem(0, this.isBorderAnimation);
            }
        } else {
            this.setCurrentItem(nextItem, true);
        }
    }

    public boolean onTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkParameterIsNotNull((Object)ev, (String)"ev");
        if (this.stopScrollWhenTouch) {
            if (ev.getAction() == 0 && this.isAutoScroll) {
                this.isStopByTouch = true;
                this.stopAutoScroll();
            } else if (ev.getAction() == 1 && this.isStopByTouch) {
                this.startAutoScroll();
            }
        }
        if (this.slideBorderMode == this.SLIDE_BORDER_MODE_TO_PARENT || this.slideBorderMode == this.SLIDE_BORDER_MODE_CYCLE) {
            int pageCount;
            PagerAdapter adapter;
            this.touchX = ev.getX();
            if (ev.getAction() == 0) {
                this.downX = this.touchX;
            }
            int currentItem = this.getCurrentItem();
            PagerAdapter pagerAdapter = adapter = this.getAdapter();
            int n = pageCount = pagerAdapter != null ? pagerAdapter.getCount() : 0;
            if (currentItem == 0 && this.downX <= this.touchX || currentItem == pageCount - 1 && this.downX >= this.touchX) {
                if (this.slideBorderMode == this.SLIDE_BORDER_MODE_TO_PARENT) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                } else {
                    if (pageCount > 1) {
                        this.setCurrentItem(pageCount - currentItem - 1, this.isBorderAnimation);
                    }
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                return super.onTouchEvent(ev);
            }
        }
        this.getParent().requestDisallowInterceptTouchEvent(true);
        return super.onTouchEvent(ev);
    }

    public final long getInterval() {
        return this.interval;
    }

    public final void setInterval(long interval) {
        this.interval = interval;
    }

    public final int getDirection() {
        return this.direction == this.LEFT ? this.LEFT : this.RIGHT;
    }

    public final void setDirection(int direction) {
        this.direction = direction;
    }

    public final boolean isCycle() {
        return this.isCycle;
    }

    public final void setCycle(boolean isCycle) {
        this.isCycle = isCycle;
    }

    public final boolean isStopScrollWhenTouch() {
        return this.stopScrollWhenTouch;
    }

    public final void setStopScrollWhenTouch(boolean stopScrollWhenTouch) {
        this.stopScrollWhenTouch = stopScrollWhenTouch;
    }

    public final int getSlideBorderMode() {
        return this.slideBorderMode;
    }

    public final void setSlideBorderMode(int slideBorderMode) {
        this.slideBorderMode = slideBorderMode;
    }

    public final boolean isBorderAnimation() {
        return this.isBorderAnimation;
    }

    public final void setBorderAnimation(boolean isBorderAnimation) {
        this.isBorderAnimation = isBorderAnimation;
    }

    public AutoScrollViewPager(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.DEFAULT_INTERVAL = 1500;
        this.RIGHT = 1;
        this.SLIDE_BORDER_MODE_CYCLE = 1;
        this.SLIDE_BORDER_MODE_TO_PARENT = 2;
        this.interval = this.DEFAULT_INTERVAL;
        this.direction = this.RIGHT;
        this.isCycle = true;
        this.stopScrollWhenTouch = true;
        this.slideBorderMode = this.SLIDE_BORDER_MODE_NONE;
        this.isBorderAnimation = true;
        this.myHandler = new MyHandler();
        this.setViewPagerScroller();
    }

    public AutoScrollViewPager(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    public static final /* synthetic */ void access$setInterval$p(AutoScrollViewPager $this, long l) {
        $this.interval = l;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lpl/pzienowicz/autoscrollviewpager/AutoScrollViewPager$MyHandler;", "Landroid/os/Handler;", "(Lpl/pzienowicz/autoscrollviewpager/AutoScrollViewPager;)V", "handleMessage", "", "msg", "Landroid/os/Message;", "autoscrollviewpager_release"})
    private final class MyHandler
    extends Handler {
        public void handleMessage(@NotNull Message msg) {
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            super.handleMessage(msg);
            if (msg.what == AutoScrollViewPager.this.getSCROLL_WHAT()) {
                AutoScrollViewPager.this.scrollOnce();
                AutoScrollViewPager.this.sendScrollMessage(AutoScrollViewPager.this.interval);
            }
        }
    }
}

