/*
 * Decompiled with CFR 0.152.
 */
package com.github.pyknic.immutablearray.internal.shorts;

import com.github.pyknic.immutablearray.IntImmutableArray;
import com.github.pyknic.immutablearray.LongImmutableArray;
import com.github.pyknic.immutablearray.ShortImmutableArray;
import com.github.pyknic.immutablearray.internal.util.IndexUtil;
import java.nio.ShortBuffer;

final class ShortMultiBufferImmutableArrayImpl
implements ShortImmutableArray,
IntImmutableArray,
LongImmutableArray {
    private final ShortBuffer[] buffers;
    private final long length;

    ShortMultiBufferImmutableArrayImpl(ShortBuffer[] buffers, long length) {
        this.buffers = buffers;
        this.length = length;
    }

    @Override
    public long getAsLong(long index) {
        return this.getAsShort(index);
    }

    @Override
    public int getAsInt(long index) {
        return this.getAsShort(index);
    }

    @Override
    public short getAsShort(long index) {
        return this.buffers[IndexUtil.outerIndex(index)].get(IndexUtil.innerIndex(index));
    }

    @Override
    public long length() {
        return this.length;
    }
}

