/*
 * Decompiled with CFR 0.152.
 */
package com.github.pyknic.immutablearray.internal.floats;

import com.github.pyknic.immutablearray.FloatImmutableArray;
import com.github.pyknic.immutablearray.internal.EmptyImmutableArray;
import com.github.pyknic.immutablearray.internal.ints.IntImmutableArrayImpl;
import com.github.pyknic.immutablearray.internal.ints.IntMultiBufferImmutableArrayImpl;
import com.github.pyknic.immutablearray.internal.ints.IntSingleBufferImmutableArrayImpl;
import com.github.pyknic.immutablearray.internal.util.MemoryUtil;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;

public final class FloatImmutableArrayBuilder
implements FloatImmutableArray.Builder {
    private final LinkedList<IntBuffer> buffers = new LinkedList();
    private int outer = 0;
    private int inner = 0;

    @Override
    public FloatImmutableArray.Builder append(float value) {
        IntBuffer current;
        if (this.outer == this.buffers.size()) {
            current = ByteBuffer.allocateDirect(0x10000000).asIntBuffer();
            this.buffers.add(current);
        } else {
            current = this.buffers.getLast();
        }
        current.put(this.inner, Float.floatToIntBits(value));
        if (0x4000000 == ++this.inner) {
            this.inner = 0;
            ++this.outer;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FloatImmutableArray build() {
        if (this.buffers.isEmpty()) {
            return new EmptyImmutableArray();
        }
        if (this.outer == 0) {
            if (this.inner < Short.MAX_VALUE) {
                IntBuffer current = this.buffers.getFirst();
                try {
                    int[] array = new int[this.inner];
                    for (int i = 0; i < this.inner; ++i) {
                        array[i] = current.get(i);
                    }
                    IntImmutableArrayImpl intImmutableArrayImpl = new IntImmutableArrayImpl(array);
                    return intImmutableArrayImpl;
                }
                finally {
                    MemoryUtil.clear(current);
                }
            }
            this.rescaleLastBuffer();
            return new IntSingleBufferImmutableArrayImpl(this.buffers.getFirst(), this.inner);
        }
        this.rescaleLastBuffer();
        return new IntMultiBufferImmutableArrayImpl(this.bufferArray(), this.length());
    }

    private long length() {
        return this.outer * 0x4000000 + this.inner;
    }

    private IntBuffer[] bufferArray() {
        return this.buffers.toArray(new IntBuffer[this.outer + 1]);
    }

    private void rescaleLastBuffer() {
        IntBuffer last = this.buffers.removeLast();
        if (this.inner > 0) {
            if (this.inner < Short.MAX_VALUE) {
                int[] temp = new int[this.inner];
                last.get(temp);
                MemoryUtil.clear(last);
                this.buffers.add(IntBuffer.wrap(temp));
            } else {
                IntBuffer temp = IntBuffer.allocate(this.inner);
                for (int i = 0; i < this.inner; ++i) {
                    temp.put(i, last.get(i));
                }
                MemoryUtil.clear(last);
                this.buffers.add(temp);
            }
        }
    }
}

