/*
 * Decompiled with CFR 0.152.
 */
package com.github.pyknic.immutablearray.internal.doubles;

import com.github.pyknic.immutablearray.DoubleImmutableArray;
import com.github.pyknic.immutablearray.internal.EmptyImmutableArray;
import com.github.pyknic.immutablearray.internal.longs.LongImmutableArrayImpl;
import com.github.pyknic.immutablearray.internal.longs.LongMultiBufferImmutableArrayImpl;
import com.github.pyknic.immutablearray.internal.longs.LongSingleBufferImmutableArrayImpl;
import com.github.pyknic.immutablearray.internal.util.MemoryUtil;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.LinkedList;

public final class DoubleImmutableArrayBuilder
implements DoubleImmutableArray.Builder {
    private final LinkedList<LongBuffer> buffers = new LinkedList();
    private int outer = 0;
    private int inner = 0;

    @Override
    public DoubleImmutableArray.Builder append(double value) {
        LongBuffer current;
        if (this.outer == this.buffers.size()) {
            current = ByteBuffer.allocateDirect(0x20000000).asLongBuffer();
            this.buffers.add(current);
        } else {
            current = this.buffers.getLast();
        }
        current.put(this.inner, Double.doubleToLongBits(value));
        if (0x4000000 == ++this.inner) {
            this.inner = 0;
            ++this.outer;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DoubleImmutableArray build() {
        if (this.buffers.isEmpty()) {
            return new EmptyImmutableArray();
        }
        if (this.outer == 0) {
            if (this.inner < Short.MAX_VALUE) {
                LongBuffer current = this.buffers.getFirst();
                try {
                    long[] array = new long[this.inner];
                    for (int i = 0; i < this.inner; ++i) {
                        array[i] = current.get(i);
                    }
                    LongImmutableArrayImpl longImmutableArrayImpl = new LongImmutableArrayImpl(array);
                    return longImmutableArrayImpl;
                }
                finally {
                    MemoryUtil.clear(current);
                }
            }
            this.rescaleLastBuffer();
            return new LongSingleBufferImmutableArrayImpl(this.buffers.getFirst(), this.inner);
        }
        this.rescaleLastBuffer();
        return new LongMultiBufferImmutableArrayImpl(this.bufferArray(), this.length());
    }

    private long length() {
        return this.outer * 0x4000000 + this.inner;
    }

    private LongBuffer[] bufferArray() {
        return this.buffers.toArray(new LongBuffer[this.outer + 1]);
    }

    private void rescaleLastBuffer() {
        LongBuffer last = this.buffers.removeLast();
        if (this.inner > 0) {
            if (this.inner < Short.MAX_VALUE) {
                long[] temp = new long[this.inner];
                last.get(temp);
                MemoryUtil.clear(last);
                this.buffers.add(LongBuffer.wrap(temp));
            } else {
                LongBuffer temp = LongBuffer.allocate(this.inner);
                for (int i = 0; i < this.inner; ++i) {
                    temp.put(i, last.get(i));
                }
                MemoryUtil.clear(last);
                this.buffers.add(temp);
            }
        }
    }
}

