/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivewifi;

public enum WifiSignalLevel {
    NO_SIGNAL(0, "no signal"),
    POOR(1, "poor"),
    FAIR(2, "fair"),
    GOOD(3, "good"),
    EXCELLENT(4, "excellent");

    public final int level;
    public final String description;

    private WifiSignalLevel(int level, String description) {
        this.level = level;
        this.description = description;
    }

    public static int getMaxLevel() {
        return WifiSignalLevel.EXCELLENT.level;
    }

    public static WifiSignalLevel fromLevel(int level) {
        switch (level) {
            case 0: {
                return NO_SIGNAL;
            }
            case 1: {
                return POOR;
            }
            case 2: {
                return FAIR;
            }
            case 3: {
                return GOOD;
            }
            case 4: {
                return EXCELLENT;
            }
        }
        return NO_SIGNAL;
    }

    public String toString() {
        return "WifiSignalLevel{level=" + this.level + ", description='" + this.description + '\'' + '}';
    }
}

