/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivewifi;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.ScanResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.github.pwittchen.reactivewifi.WifiSignalLevel;
import com.github.pwittchen.reactivewifi.WifiState;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.functions.Action;
import io.reactivex.functions.Function;
import java.util.List;

public class ReactiveWifi {
    private static final String LOG_TAG = "ReactiveWifi";

    private ReactiveWifi() {
    }

    @SuppressLint(value={"MissingPermission"})
    @RequiresPermission(allOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.CHANGE_WIFI_STATE", "android.permission.ACCESS_WIFI_STATE"})
    public static Observable<List<ScanResult>> observeWifiAccessPoints(final Context context) {
        final WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        if (wifiManager != null) {
            wifiManager.startScan();
        } else {
            Log.w((String)LOG_TAG, (String)"WifiManager was null, so WiFi scan was not started");
        }
        final IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.wifi.RSSI_CHANGED");
        filter.addAction("android.net.wifi.SCAN_RESULTS");
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<List<ScanResult>>(){

            public void subscribe(ObservableEmitter<List<ScanResult>> emitter) throws Exception {
                final BroadcastReceiver receiver = ReactiveWifi.createWifiScanResultsReceiver(emitter, wifiManager);
                if (wifiManager != null) {
                    context.registerReceiver(receiver, filter);
                } else {
                    emitter.onError((Throwable)new RuntimeException("WifiManager was null, so BroadcastReceiver for Wifi scan results cannot be registered"));
                }
                Disposable disposable = ReactiveWifi.disposeInUiThread(new Action(){

                    public void run() {
                        ReactiveWifi.tryToUnregisterReceiver(context, receiver);
                    }
                });
                emitter.setDisposable(disposable);
            }
        });
    }

    @NonNull
    protected static BroadcastReceiver createWifiScanResultsReceiver(final ObservableEmitter<List<ScanResult>> emitter, final WifiManager wifiManager) {
        return new BroadcastReceiver(){

            public void onReceive(Context context1, Intent intent) {
                wifiManager.startScan();
                emitter.onNext((Object)wifiManager.getScanResults());
            }
        };
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static Observable<WifiSignalLevel> observeWifiSignalLevel(Context context) {
        return ReactiveWifi.observeWifiSignalLevel(context, WifiSignalLevel.getMaxLevel()).map((Function)new Function<Integer, WifiSignalLevel>(){

            public WifiSignalLevel apply(Integer level) throws Exception {
                return WifiSignalLevel.fromLevel(level);
            }
        });
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static Observable<Integer> observeWifiSignalLevel(final Context context, final int numLevels) {
        final WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        final IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.wifi.RSSI_CHANGED");
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Integer>(){

            public void subscribe(ObservableEmitter<Integer> emitter) throws Exception {
                final BroadcastReceiver receiver = ReactiveWifi.createSignalLevelReceiver(emitter, wifiManager, numLevels);
                if (wifiManager != null) {
                    context.registerReceiver(receiver, filter);
                } else {
                    emitter.onError((Throwable)new RuntimeException("WifiManager is null, so BroadcastReceiver for Wifi signal level cannot be registered"));
                }
                Disposable disposable = ReactiveWifi.disposeInUiThread(new Action(){

                    public void run() {
                        ReactiveWifi.tryToUnregisterReceiver(context, receiver);
                    }
                });
                emitter.setDisposable(disposable);
            }
        }).defaultIfEmpty((Object)0);
    }

    @NonNull
    protected static BroadcastReceiver createSignalLevelReceiver(final ObservableEmitter<Integer> emitter, final WifiManager wifiManager, final int numLevels) {
        return new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                int rssi = wifiManager.getConnectionInfo().getRssi();
                int level = WifiManager.calculateSignalLevel((int)rssi, (int)numLevels);
                emitter.onNext((Object)level);
            }
        };
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static Observable<SupplicantState> observeSupplicantState(final Context context) {
        final IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.wifi.supplicant.STATE_CHANGE");
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<SupplicantState>(){

            public void subscribe(ObservableEmitter<SupplicantState> emitter) throws Exception {
                final BroadcastReceiver receiver = ReactiveWifi.createSupplicantStateReceiver(emitter);
                context.registerReceiver(receiver, filter);
                Disposable disposable = ReactiveWifi.disposeInUiThread(new Action(){

                    public void run() {
                        ReactiveWifi.tryToUnregisterReceiver(context, receiver);
                    }
                });
                emitter.setDisposable(disposable);
            }
        }).defaultIfEmpty((Object)SupplicantState.UNINITIALIZED);
    }

    @NonNull
    protected static BroadcastReceiver createSupplicantStateReceiver(final ObservableEmitter<SupplicantState> emitter) {
        return new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                SupplicantState supplicantState = (SupplicantState)intent.getParcelableExtra("newState");
                if (supplicantState != null && SupplicantState.isValidState((SupplicantState)supplicantState)) {
                    emitter.onNext((Object)supplicantState);
                }
            }
        };
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static Observable<WifiInfo> observeWifiAccessPointChanges(final Context context) {
        final WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        final IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.wifi.supplicant.STATE_CHANGE");
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<WifiInfo>(){

            public void subscribe(ObservableEmitter<WifiInfo> emitter) throws Exception {
                final BroadcastReceiver receiver = ReactiveWifi.createAccessPointChangesReceiver(emitter, wifiManager);
                context.registerReceiver(receiver, filter);
                Disposable disposable = ReactiveWifi.disposeInUiThread(new Action(){

                    public void run() {
                        ReactiveWifi.tryToUnregisterReceiver(context, receiver);
                    }
                });
                emitter.setDisposable(disposable);
            }
        });
    }

    @NonNull
    protected static BroadcastReceiver createAccessPointChangesReceiver(final ObservableEmitter<WifiInfo> emitter, final WifiManager wifiManager) {
        return new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                SupplicantState supplicantState = (SupplicantState)intent.getParcelableExtra("newState");
                if (supplicantState == SupplicantState.COMPLETED) {
                    emitter.onNext((Object)wifiManager.getConnectionInfo());
                }
            }
        };
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static Observable<WifiState> observeWifiStateChange(final Context context) {
        final IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<WifiState>(){

            public void subscribe(ObservableEmitter<WifiState> emitter) throws Exception {
                final BroadcastReceiver receiver = ReactiveWifi.createWifiStateChangeReceiver(emitter);
                context.registerReceiver(receiver, filter);
                Disposable disposable = ReactiveWifi.disposeInUiThread(new Action(){

                    public void run() {
                        ReactiveWifi.tryToUnregisterReceiver(context, receiver);
                    }
                });
                emitter.setDisposable(disposable);
            }
        });
    }

    @NonNull
    protected static BroadcastReceiver createWifiStateChangeReceiver(final ObservableEmitter<WifiState> emitter) {
        return new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                int wifiState = intent.getIntExtra("wifi_state", 4);
                emitter.onNext((Object)WifiState.fromState(wifiState));
            }
        };
    }

    protected static void tryToUnregisterReceiver(Context context, BroadcastReceiver receiver) {
        try {
            context.unregisterReceiver(receiver);
        }
        catch (Exception exception) {
            ReactiveWifi.onError("receiver was already unregistered", exception);
        }
    }

    protected static void onError(String message, Exception exception) {
        Log.e((String)LOG_TAG, (String)message, (Throwable)exception);
    }

    private static Disposable disposeInUiThread(final Action action) {
        return Disposables.fromAction((Action)new Action(){

            public void run() throws Exception {
                if (Looper.getMainLooper() == Looper.myLooper()) {
                    action.run();
                } else {
                    final Scheduler.Worker inner = AndroidSchedulers.mainThread().createWorker();
                    inner.schedule(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                action.run();
                            }
                            catch (Exception e) {
                                ReactiveWifi.onError("Could not unregister receiver in UI Thread", e);
                            }
                            inner.dispose();
                        }
                    });
                }
            }
        });
    }
}

