/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library.rx2;

import android.content.Context;
import android.support.annotation.RequiresPermission;
import com.github.pwittchen.reactivenetwork.library.rx2.Connectivity;
import com.github.pwittchen.reactivenetwork.library.rx2.Preconditions;
import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.InternetObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.error.DefaultErrorHandler;
import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.error.ErrorHandler;
import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.strategy.WalledGardenInternetObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.rx2.network.observing.NetworkObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.rx2.network.observing.strategy.LollipopNetworkObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.rx2.network.observing.strategy.MarshmallowNetworkObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.rx2.network.observing.strategy.PreLollipopNetworkObservingStrategy;
import io.reactivex.Observable;
import io.reactivex.Single;

public class ReactiveNetwork {
    public static final String LOG_TAG = "ReactiveNetwork";
    private static final String DEFAULT_PING_HOST = "http://clients3.google.com/generate_204";
    private static final int DEFAULT_PING_PORT = 80;
    private static final int DEFAULT_PING_INTERVAL_IN_MS = 2000;
    private static final int DEFAULT_INITIAL_PING_INTERVAL_IN_MS = 0;
    private static final int DEFAULT_PING_TIMEOUT_IN_MS = 2000;

    protected ReactiveNetwork() {
    }

    public static ReactiveNetwork create() {
        return new ReactiveNetwork();
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static Observable<Connectivity> observeNetworkConnectivity(Context context) {
        NetworkObservingStrategy strategy = Preconditions.isAtLeastAndroidMarshmallow() ? new MarshmallowNetworkObservingStrategy() : (Preconditions.isAtLeastAndroidLollipop() ? new LollipopNetworkObservingStrategy() : new PreLollipopNetworkObservingStrategy());
        return ReactiveNetwork.observeNetworkConnectivity(context, strategy);
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static Observable<Connectivity> observeNetworkConnectivity(Context context, NetworkObservingStrategy strategy) {
        Preconditions.checkNotNull(context, "context == null");
        Preconditions.checkNotNull(strategy, "strategy == null");
        return strategy.observeNetworkConnectivity(context);
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Observable<Boolean> observeInternetConnectivity() {
        return ReactiveNetwork.observeInternetConnectivity(0, 2000, DEFAULT_PING_HOST, 80, 2000, new DefaultErrorHandler());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Observable<Boolean> observeInternetConnectivity(InternetObservingStrategy strategy) {
        ReactiveNetwork.checkStrategyIsNotNull(strategy);
        return strategy.observeInternetConnectivity(0, 2000, strategy.getDefaultPingHost(), 80, 2000, new DefaultErrorHandler());
    }

    public static Observable<Boolean> observeInternetConnectivity(InternetObservingStrategy strategy, String host) {
        ReactiveNetwork.checkStrategyIsNotNull(strategy);
        return strategy.observeInternetConnectivity(0, 2000, host, 80, 2000, new DefaultErrorHandler());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Observable<Boolean> observeInternetConnectivity(int intervalInMs, String host, int port, int timeoutInMs) {
        return ReactiveNetwork.observeInternetConnectivity(0, intervalInMs, host, port, timeoutInMs, new DefaultErrorHandler());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Observable<Boolean> observeInternetConnectivity(int initialIntervalInMs, int intervalInMs, String host, int port, int timeoutInMs) {
        return ReactiveNetwork.observeInternetConnectivity(initialIntervalInMs, intervalInMs, host, port, timeoutInMs, new DefaultErrorHandler());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Observable<Boolean> observeInternetConnectivity(int initialIntervalInMs, int intervalInMs, String host, int port, int timeoutInMs, ErrorHandler errorHandler) {
        return ReactiveNetwork.observeInternetConnectivity(new WalledGardenInternetObservingStrategy(), initialIntervalInMs, intervalInMs, host, port, timeoutInMs, errorHandler);
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Observable<Boolean> observeInternetConnectivity(InternetObservingStrategy strategy, int initialIntervalInMs, int intervalInMs, String host, int port, int timeoutInMs, ErrorHandler errorHandler) {
        ReactiveNetwork.checkStrategyIsNotNull(strategy);
        return strategy.observeInternetConnectivity(initialIntervalInMs, intervalInMs, host, port, timeoutInMs, errorHandler);
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Single<Boolean> checkInternetConnectivity() {
        return ReactiveNetwork.checkInternetConnectivity(DEFAULT_PING_HOST, 80, 2000, new DefaultErrorHandler());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Single<Boolean> checkInternetConnectivity(InternetObservingStrategy strategy) {
        ReactiveNetwork.checkStrategyIsNotNull(strategy);
        return strategy.checkInternetConnectivity(strategy.getDefaultPingHost(), 80, 2000, new DefaultErrorHandler());
    }

    public static Single<Boolean> checkInternetConnectivity(InternetObservingStrategy strategy, String host) {
        ReactiveNetwork.checkStrategyIsNotNull(strategy);
        return strategy.checkInternetConnectivity(host, 80, 2000, new DefaultErrorHandler());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Single<Boolean> checkInternetConnectivity(String host, int port, int timeoutInMs) {
        return ReactiveNetwork.checkInternetConnectivity(host, port, timeoutInMs, new DefaultErrorHandler());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Single<Boolean> checkInternetConnectivity(String host, int port, int timeoutInMs, ErrorHandler errorHandler) {
        return ReactiveNetwork.checkInternetConnectivity(new WalledGardenInternetObservingStrategy(), host, port, timeoutInMs, errorHandler);
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Single<Boolean> checkInternetConnectivity(InternetObservingStrategy strategy, String host, int port, int timeoutInMs, ErrorHandler errorHandler) {
        ReactiveNetwork.checkStrategyIsNotNull(strategy);
        return strategy.checkInternetConnectivity(host, port, timeoutInMs, errorHandler);
    }

    private static void checkStrategyIsNotNull(InternetObservingStrategy strategy) {
        Preconditions.checkNotNull(strategy, "strategy == null");
    }
}

