/*
 * Decompiled with CFR 0.152.
 */
package com.github.pukkaone.jsp;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JspCompileListener
implements ServletContextListener {
    private ServletContext servletContext;
    private HttpServletRequest request = this.createHttpServletRequest();
    private HttpServletResponse response = this.createHttpServletResponse();

    private HttpServletRequest createHttpServletRequest() {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("getQueryString")) {
                    return "jsp_precompile";
                }
                return null;
            }
        };
        return (HttpServletRequest)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpServletRequest.class}, handler);
    }

    private HttpServletResponse createHttpServletResponse() {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        };
        return (HttpServletResponse)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpServletResponse.class}, handler);
    }

    private void compileJspsInDirectory(String dirPath) {
        Set paths = this.servletContext.getResourcePaths(dirPath);
        for (String path : paths) {
            if (path.endsWith(".jsp")) {
                RequestDispatcher requestDispatcher = this.servletContext.getRequestDispatcher(path);
                if (requestDispatcher == null) {
                    throw new Error(path + " not found");
                }
                try {
                    this.servletContext.log("Compiling " + path);
                    requestDispatcher.include((ServletRequest)this.request, (ServletResponse)this.response);
                }
                catch (Exception e) {
                    this.servletContext.log("include", (Throwable)e);
                }
                continue;
            }
            if (!path.endsWith("/")) continue;
            this.compileJspsInDirectory(path);
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        this.servletContext = event.getServletContext();
        this.compileJspsInDirectory("/");
    }

    public void contextDestroyed(ServletContextEvent event) {
    }
}

