/*
 * Decompiled with CFR 0.152.
 */
package com.github.pukkaone.jsp;

public class EscapeXml {
    private static final String[] ESCAPES;

    private static String getEscape(char c) {
        if (c < ESCAPES.length) {
            return ESCAPES[c];
        }
        return null;
    }

    public static String escape(String src) {
        int length = 0;
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            String escape = EscapeXml.getEscape(c);
            if (escape != null) {
                length += escape.length();
                continue;
            }
            ++length;
        }
        if (length == src.length()) {
            return src;
        }
        StringBuilder buf = new StringBuilder(length);
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            String escape = EscapeXml.getEscape(c);
            if (escape != null) {
                buf.append(escape);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    static {
        int size = 63;
        ESCAPES = new String[size];
        EscapeXml.ESCAPES[60] = "&lt;";
        EscapeXml.ESCAPES[62] = "&gt;";
        EscapeXml.ESCAPES[38] = "&amp;";
        EscapeXml.ESCAPES[39] = "&#039;";
        EscapeXml.ESCAPES[34] = "&#034;";
    }
}

