/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.stetho_realm;

import android.database.sqlite.SQLiteException;
import com.facebook.stetho.inspector.helper.ChromePeerManager;
import com.facebook.stetho.inspector.helper.PeerRegistrationListener;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcPeer;
import com.uphyca.stetho_realm.Database;
import com.uphyca.stetho_realm.RealmFilesProvider;
import io.realm.RealmConfiguration;
import io.realm.exceptions.RealmError;
import io.realm.internal.OsRealmConfig;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.Table;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class RealmPeerManager
extends ChromePeerManager {
    private static final String TABLE_PREFIX = "class_";
    private final String packageName;
    private final RealmFilesProvider realmFilesProvider;
    private byte[] defaultEncryptionKey;
    private Map<String, byte[]> encryptionKeys;
    private static final Pattern SELECT_PATTERN = Pattern.compile("SELECT[ \\t]+rowid,[ \\t]+\\*[ \\t]+FROM \"([^\"]+)\"");

    public RealmPeerManager(String packageName, RealmFilesProvider filesProvider, byte[] defaultEncryptionKey, Map<String, byte[]> encryptionKeys) {
        this.packageName = packageName;
        this.realmFilesProvider = filesProvider;
        this.defaultEncryptionKey = defaultEncryptionKey;
        this.encryptionKeys = encryptionKeys;
        this.setListener(new PeerRegistrationListener(){

            public void onPeerRegistered(JsonRpcPeer peer) {
                RealmPeerManager.this.bootstrapNewPeer(peer);
            }

            public void onPeerUnregistered(JsonRpcPeer peer) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDatabaseTableNames(String databaseId, boolean withMetaTables) {
        ArrayList<String> tableNames = new ArrayList<String>();
        try (OsSharedRealm sharedRealm = this.openSharedRealm(databaseId);){
            int i = 0;
            while ((long)i < sharedRealm.size()) {
                String tableName = sharedRealm.getTableName(i);
                if (withMetaTables || tableName.startsWith(TABLE_PREFIX)) {
                    tableNames.add(tableName);
                }
                ++i;
            }
        }
        return tableNames;
    }

    private void bootstrapNewPeer(JsonRpcPeer peer) {
        List<File> potentialDatabaseFiles = this.realmFilesProvider.getDatabaseFiles();
        List<File> tidiedList = RealmPeerManager.tidyDatabaseList(potentialDatabaseFiles);
        for (File database : tidiedList) {
            Database.DatabaseObject databaseParams = new Database.DatabaseObject();
            databaseParams.id = database.getPath();
            databaseParams.name = database.getName();
            databaseParams.domain = this.packageName;
            databaseParams.version = "N/A";
            Database.AddDatabaseEvent eventParams = new Database.AddDatabaseEvent();
            eventParams.database = databaseParams;
            peer.invokeMethod("Database.addDatabase", (Object)eventParams, null);
        }
    }

    static List<File> tidyDatabaseList(List<File> databaseFiles) {
        ArrayList<File> tidiedList = new ArrayList<File>();
        for (File databaseFile : databaseFiles) {
            tidiedList.add(databaseFile);
        }
        return tidiedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeSQL(String databaseId, String query, ExecuteResultHandler<T> executeResultHandler) {
        try (OsSharedRealm sharedRealm = this.openSharedRealm(databaseId);){
            query = query.trim();
            Matcher selectMatcher = SELECT_PATTERN.matcher(query);
            if (selectMatcher.matches()) {
                String tableName = selectMatcher.group(1);
                Table table = sharedRealm.getTable(tableName);
                T t = executeResultHandler.handleSelect(table, true);
                return t;
            }
            T t = null;
            return t;
        }
    }

    private OsSharedRealm openSharedRealm(String databaseId) {
        return this.openSharedRealm(databaseId, null);
    }

    private OsSharedRealm openSharedRealm(String databaseId, @Nullable OsRealmConfig.Durability durability) {
        byte[] encryptionKey = this.getEncryptionKey(databaseId);
        RealmConfiguration.Builder builder = new RealmConfiguration.Builder();
        File databaseFile = new File(databaseId).getAbsoluteFile();
        builder.directory(databaseFile.getParentFile());
        builder.name(databaseFile.getName());
        if (durability == OsRealmConfig.Durability.MEM_ONLY) {
            builder.inMemory();
        }
        if (encryptionKey != null) {
            builder.encryptionKey(encryptionKey);
        }
        try {
            return OsSharedRealm.getInstance((RealmConfiguration)builder.build());
        }
        catch (RealmError e) {
            if (durability == null) {
                builder.inMemory();
                return OsSharedRealm.getInstance((RealmConfiguration)builder.build());
            }
            throw e;
        }
    }

    private Class<?> getRealmErrorClass() {
        try {
            return Class.forName("io.realm.exceptions.RealmError");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private byte[] getEncryptionKey(String databaseId) {
        String databaseName = new File(databaseId).getName();
        if (this.encryptionKeys.containsKey(databaseName)) {
            return this.encryptionKeys.get(databaseName);
        }
        return this.defaultEncryptionKey;
    }

    public static interface ExecuteResultHandler<T> {
        public T handleRawQuery() throws SQLiteException;

        public T handleSelect(Table var1, boolean var2) throws SQLiteException;

        public T handleInsert(long var1) throws SQLiteException;

        public T handleUpdateDelete(int var1) throws SQLiteException;
    }
}

