/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.stetho_realm;

import android.database.sqlite.SQLiteException;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcPeer;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcResult;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsDomain;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsMethod;
import com.facebook.stetho.json.ObjectMapper;
import com.facebook.stetho.json.annotation.JsonProperty;
import com.uphyca.stetho_realm.RealmFilesProvider;
import com.uphyca.stetho_realm.RealmPeerManager;
import io.realm.RealmFieldType;
import io.realm.internal.OsList;
import io.realm.internal.Row;
import io.realm.internal.Table;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class Database
implements ChromeDevtoolsDomain {
    private static final String NULL = "[null]";
    private final RealmPeerManager realmPeerManager;
    private final ObjectMapper objectMapper;
    private final boolean withMetaTables;
    private final long limit;
    private final boolean ascendingOrder;
    private DateFormat dateTimeFormatter;

    Database(String packageName, RealmFilesProvider filesProvider, boolean withMetaTables, long limit, boolean ascendingOrder, byte[] defaultEncryptionKey, Map<String, byte[]> encryptionKeys) {
        this.realmPeerManager = new RealmPeerManager(packageName, filesProvider, defaultEncryptionKey, encryptionKeys);
        this.objectMapper = new ObjectMapper();
        this.withMetaTables = withMetaTables;
        this.limit = limit;
        this.ascendingOrder = ascendingOrder;
    }

    @ChromeDevtoolsMethod
    public void enable(JsonRpcPeer peer, JSONObject params) {
        this.realmPeerManager.addPeer(peer);
    }

    @ChromeDevtoolsMethod
    public void disable(JsonRpcPeer peer, JSONObject params) {
        this.realmPeerManager.removePeer(peer);
    }

    @ChromeDevtoolsMethod
    public JsonRpcResult getDatabaseTableNames(JsonRpcPeer peer, JSONObject params) {
        GetDatabaseTableNamesRequest request = (GetDatabaseTableNamesRequest)this.objectMapper.convertValue((Object)params, GetDatabaseTableNamesRequest.class);
        GetDatabaseTableNamesResponse response = new GetDatabaseTableNamesResponse();
        response.tableNames = this.realmPeerManager.getDatabaseTableNames(request.databaseId, this.withMetaTables);
        return response;
    }

    @ChromeDevtoolsMethod
    public JsonRpcResult executeSQL(JsonRpcPeer peer, JSONObject params) {
        ExecuteSQLRequest request = (ExecuteSQLRequest)this.objectMapper.convertValue((Object)params, ExecuteSQLRequest.class);
        try {
            return this.realmPeerManager.executeSQL(request.databaseId, request.query, new RealmPeerManager.ExecuteResultHandler<ExecuteSQLResponse>(){

                @Override
                public ExecuteSQLResponse handleRawQuery() throws SQLiteException {
                    ExecuteSQLResponse response = new ExecuteSQLResponse();
                    response.columnNames = Collections.singletonList("success");
                    response.values = Collections.singletonList("true");
                    return response;
                }

                @Override
                public ExecuteSQLResponse handleSelect(Table table, boolean addRowIndex) throws SQLiteException {
                    ExecuteSQLResponse response = new ExecuteSQLResponse();
                    ArrayList<String> columnNames = new ArrayList<String>();
                    if (addRowIndex) {
                        columnNames.add("<index>");
                    }
                    int i = 0;
                    while ((long)i < table.getColumnCount()) {
                        columnNames.add(table.getColumnName((long)i));
                        ++i;
                    }
                    response.columnNames = columnNames;
                    response.values = Database.this.flattenRows(table, Database.this.limit, addRowIndex);
                    return response;
                }

                @Override
                public ExecuteSQLResponse handleInsert(long insertedId) throws SQLiteException {
                    ExecuteSQLResponse response = new ExecuteSQLResponse();
                    response.columnNames = Collections.singletonList("ID of last inserted row");
                    response.values = Collections.singletonList(insertedId);
                    return response;
                }

                @Override
                public ExecuteSQLResponse handleUpdateDelete(int count) throws SQLiteException {
                    ExecuteSQLResponse response = new ExecuteSQLResponse();
                    response.columnNames = Collections.singletonList("Modified rows");
                    response.values = Collections.singletonList(count);
                    return response;
                }
            });
        }
        catch (SQLiteException e) {
            Error error = new Error();
            error.code = 0;
            error.message = e.getMessage();
            ExecuteSQLResponse response = new ExecuteSQLResponse();
            response.sqlError = error;
            return response;
        }
    }

    private List<Object> flattenRows(Table table, long limit, boolean addRowIndex) {
        Util.throwIfNot((limit >= 0L ? 1 : 0) != 0);
        ArrayList<Object> flatList = new ArrayList<Object>();
        long numColumns = table.getColumnCount();
        RowFetcher rowFetcher = RowFetcher.getInstance();
        long tableSize = table.size();
        for (long index = 0L; index < limit && index < tableSize; ++index) {
            long row = this.ascendingOrder ? index : tableSize - index - 1L;
            RowWrapper rowData = RowWrapper.wrap(rowFetcher.getRow(table, row));
            if (addRowIndex) {
                flatList.add(rowData.getIndex());
            }
            int column = 0;
            while ((long)column < numColumns) {
                switch (rowData.getColumnType(column)) {
                    case INTEGER: {
                        if (rowData.isNull(column)) {
                            flatList.add(NULL);
                            break;
                        }
                        flatList.add(rowData.getLong(column));
                        break;
                    }
                    case BOOLEAN: {
                        if (rowData.isNull(column)) {
                            flatList.add(NULL);
                            break;
                        }
                        flatList.add(rowData.getBoolean(column));
                        break;
                    }
                    case STRING: {
                        if (rowData.isNull(column)) {
                            flatList.add(NULL);
                            break;
                        }
                        flatList.add(rowData.getString(column));
                        break;
                    }
                    case BINARY: {
                        if (rowData.isNull(column)) {
                            flatList.add(NULL);
                            break;
                        }
                        flatList.add(rowData.getBinaryByteArray(column));
                        break;
                    }
                    case FLOAT: {
                        if (rowData.isNull(column)) {
                            flatList.add(NULL);
                            break;
                        }
                        float aFloat = rowData.getFloat(column);
                        if (Float.isNaN(aFloat)) {
                            flatList.add("NaN");
                            break;
                        }
                        if (aFloat == Float.POSITIVE_INFINITY) {
                            flatList.add("Infinity");
                            break;
                        }
                        if (aFloat == Float.NEGATIVE_INFINITY) {
                            flatList.add("-Infinity");
                            break;
                        }
                        flatList.add(Float.valueOf(aFloat));
                        break;
                    }
                    case DOUBLE: {
                        if (rowData.isNull(column)) {
                            flatList.add(NULL);
                            break;
                        }
                        double aDouble = rowData.getDouble(column);
                        if (Double.isNaN(aDouble)) {
                            flatList.add("NaN");
                            break;
                        }
                        if (aDouble == Double.POSITIVE_INFINITY) {
                            flatList.add("Infinity");
                            break;
                        }
                        if (aDouble == Double.NEGATIVE_INFINITY) {
                            flatList.add("-Infinity");
                            break;
                        }
                        flatList.add(aDouble);
                        break;
                    }
                    case OLD_DATE: 
                    case DATE: {
                        if (rowData.isNull(column)) {
                            flatList.add(NULL);
                            break;
                        }
                        flatList.add(this.formatDate(rowData.getDate(column)));
                        break;
                    }
                    case OBJECT: {
                        if (rowData.isNullLink(column)) {
                            flatList.add(NULL);
                            break;
                        }
                        flatList.add(rowData.getLink(column));
                        break;
                    }
                    case LIST: {
                        flatList.add(this.formatList(rowData.getLinkList(column)));
                        break;
                    }
                    case INTEGER_LIST: 
                    case BOOLEAN_LIST: 
                    case DOUBLE_LIST: 
                    case STRING_LIST: 
                    case BINARY_LIST: 
                    case DATE_LIST: 
                    case FLOAT_LIST: {
                        if (rowData.isNullLink(column)) {
                            flatList.add(NULL);
                            break;
                        }
                        RealmFieldType columnType = table.getColumnType((long)column);
                        flatList.add(this.formatValueList(rowData.getValueList(column, columnType), columnType));
                        break;
                    }
                    default: {
                        flatList.add("unknown column type: " + (Object)((Object)rowData.getColumnType(column)));
                    }
                }
                ++column;
            }
        }
        if (limit < table.size()) {
            int column = 0;
            while ((long)column < numColumns) {
                flatList.add("{truncated}");
                ++column;
            }
        }
        return flatList;
    }

    private String formatValueList(OsList linkList, RealmFieldType columnType) {
        StringBuilder sb = new StringBuilder(columnType.name());
        sb.append("{");
        long size = linkList.size();
        for (long pos = 0L; pos < size; ++pos) {
            sb.append(linkList.getValue(pos));
            sb.append(',');
        }
        if (size != 0L) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    private String formatDate(Date date) {
        if (this.dateTimeFormatter == null) {
            this.dateTimeFormatter = SimpleDateFormat.getDateTimeInstance(1, 1);
        }
        return this.dateTimeFormatter.format(date) + " (" + date.getTime() + ')';
    }

    private String formatList(OsList linkList) {
        StringBuilder sb = new StringBuilder(linkList.getTargetTable().getName());
        sb.append("{");
        long size = linkList.size();
        for (long pos = 0L; pos < size; ++pos) {
            sb.append(linkList.getUncheckedRow(pos).getIndex());
            sb.append(',');
        }
        if (size != 0L) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    static class RowWrapper {
        private final Row row;

        static RowWrapper wrap(Row row) {
            return new RowWrapper(row);
        }

        RowWrapper(Row row) {
            this.row = row;
        }

        long getIndex() {
            return this.row.getIndex();
        }

        StethoRealmFieldType getColumnType(long columnIndex) {
            RealmFieldType columnType = this.row.getColumnType(columnIndex);
            String name = columnType.name();
            if (name.equals("INTEGER")) {
                return StethoRealmFieldType.INTEGER;
            }
            if (name.equals("BOOLEAN")) {
                return StethoRealmFieldType.BOOLEAN;
            }
            if (name.equals("STRING")) {
                return StethoRealmFieldType.STRING;
            }
            if (name.equals("BINARY")) {
                return StethoRealmFieldType.BINARY;
            }
            if (name.equals("UNSUPPORTED_TABLE")) {
                return StethoRealmFieldType.UNSUPPORTED_TABLE;
            }
            if (name.equals("UNSUPPORTED_MIXED")) {
                return StethoRealmFieldType.UNSUPPORTED_MIXED;
            }
            if (name.equals("UNSUPPORTED_DATE")) {
                return StethoRealmFieldType.OLD_DATE;
            }
            if (name.equals("DATE")) {
                return StethoRealmFieldType.DATE;
            }
            if (name.equals("FLOAT")) {
                return StethoRealmFieldType.FLOAT;
            }
            if (name.equals("DOUBLE")) {
                return StethoRealmFieldType.DOUBLE;
            }
            if (name.equals("OBJECT")) {
                return StethoRealmFieldType.OBJECT;
            }
            if (name.equals("LIST")) {
                return StethoRealmFieldType.LIST;
            }
            if (name.equals("INTEGER_LIST")) {
                return StethoRealmFieldType.INTEGER_LIST;
            }
            if (name.equals("BOOLEAN_LIST")) {
                return StethoRealmFieldType.BOOLEAN_LIST;
            }
            if (name.equals("DOUBLE_LIST")) {
                return StethoRealmFieldType.DOUBLE_LIST;
            }
            if (name.equals("STRING_LIST")) {
                return StethoRealmFieldType.STRING_LIST;
            }
            if (name.equals("BINARY_LIST")) {
                return StethoRealmFieldType.BINARY_LIST;
            }
            if (name.equals("DATE_LIST")) {
                return StethoRealmFieldType.DATE_LIST;
            }
            if (name.equals("FLOAT_LIST")) {
                return StethoRealmFieldType.FLOAT_LIST;
            }
            return StethoRealmFieldType.UNKNOWN;
        }

        boolean isNull(long columnIndex) {
            return this.row.isNull(columnIndex);
        }

        boolean isNullLink(long columnIndex) {
            return this.row.isNullLink(columnIndex);
        }

        long getLong(long columnIndex) {
            return this.row.getLong(columnIndex);
        }

        boolean getBoolean(long columnIndex) {
            return this.row.getBoolean(columnIndex);
        }

        float getFloat(long columnIndex) {
            return this.row.getFloat(columnIndex);
        }

        double getDouble(long columnIndex) {
            return this.row.getDouble(columnIndex);
        }

        Date getDate(long columnIndex) {
            return this.row.getDate(columnIndex);
        }

        String getString(long columnIndex) {
            return this.row.getString(columnIndex);
        }

        byte[] getBinaryByteArray(long columnIndex) {
            return this.row.getBinaryByteArray(columnIndex);
        }

        long getLink(long columnIndex) {
            return this.row.getLink(columnIndex);
        }

        OsList getLinkList(long columnIndex) {
            return this.row.getModelList(columnIndex);
        }

        OsList getValueList(long columnIndex, RealmFieldType fieldType) {
            return this.row.getValueList(columnIndex, fieldType);
        }
    }

    static class RowFetcher {
        private static RowFetcher sInstance = new RowFetcher();

        static RowFetcher getInstance() {
            return sInstance;
        }

        RowFetcher() {
        }

        Row getRow(Table targetTable, long index) {
            return targetTable.getCheckedRow(index);
        }
    }

    public static class Error {
        @JsonProperty(required=true)
        public String message;
        @JsonProperty(required=true)
        public int code;
    }

    public static class DatabaseObject {
        @JsonProperty(required=true)
        public String id;
        @JsonProperty(required=true)
        public String domain;
        @JsonProperty(required=true)
        public String name;
        @JsonProperty(required=true)
        public String version;
    }

    public static class AddDatabaseEvent {
        @JsonProperty(required=true)
        public DatabaseObject database;
    }

    private static class ExecuteSQLResponse
    implements JsonRpcResult {
        @JsonProperty
        public List<String> columnNames;
        @JsonProperty
        public List<Object> values;
        @JsonProperty
        public Error sqlError;

        private ExecuteSQLResponse() {
        }
    }

    private static class ExecuteSQLRequest {
        @JsonProperty(required=true)
        public String databaseId;
        @JsonProperty(required=true)
        public String query;

        private ExecuteSQLRequest() {
        }
    }

    private static class GetDatabaseTableNamesResponse
    implements JsonRpcResult {
        @JsonProperty(required=true)
        public List<String> tableNames;

        private GetDatabaseTableNamesResponse() {
        }
    }

    private static class GetDatabaseTableNamesRequest {
        @JsonProperty(required=true)
        public String databaseId;

        private GetDatabaseTableNamesRequest() {
        }
    }

    private static enum StethoRealmFieldType {
        INTEGER(0),
        BOOLEAN(1),
        STRING(2),
        BINARY(4),
        UNSUPPORTED_TABLE(5),
        UNSUPPORTED_MIXED(6),
        OLD_DATE(7),
        DATE(8),
        FLOAT(9),
        DOUBLE(10),
        OBJECT(12),
        LIST(13),
        INTEGER_LIST(15),
        BOOLEAN_LIST(16),
        STRING_LIST(17),
        BINARY_LIST(18),
        DATE_LIST(19),
        FLOAT_LIST(20),
        DOUBLE_LIST(21),
        UNKNOWN(-1);

        private final int nativeValue;

        private StethoRealmFieldType(int nativeValue) {
            this.nativeValue = nativeValue;
        }

        public int getValue() {
            return this.nativeValue;
        }
    }
}

