/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools.logging.slf4jlogback;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.reflect.MethodUtils;
import psiprobe.tools.logging.DefaultAccessor;
import psiprobe.tools.logging.slf4jlogback.TomcatSlf4jLogbackAppenderAccessor;
import psiprobe.tools.logging.slf4jlogback.TomcatSlf4jLogbackLoggerAccessor;

public class TomcatSlf4jLogbackFactoryAccessor
extends DefaultAccessor {
    public TomcatSlf4jLogbackFactoryAccessor(ClassLoader cl) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = cl.loadClass("org.apache.juli.logging.org.slf4j.impl.StaticLoggerBinder");
        Method getSingleton = MethodUtils.getAccessibleMethod(clazz, (String)"getSingleton", (Class[])new Class[0]);
        Object singleton = getSingleton.invoke(null, new Object[0]);
        Method getLoggerFactory = MethodUtils.getAccessibleMethod(clazz, (String)"getLoggerFactory", (Class[])new Class[0]);
        Object loggerFactory = getLoggerFactory.invoke(singleton, new Object[0]);
        Class<?> loggerFactoryClass = cl.loadClass("org.apache.juli.logging.ch.qos.logback.classic.LoggerContext");
        if (!loggerFactoryClass.isInstance(loggerFactory)) {
            throw new RuntimeException("The singleton SLF4J binding was not Logback");
        }
        this.setTarget(loggerFactory);
    }

    public TomcatSlf4jLogbackLoggerAccessor getRootLogger() {
        return this.getLogger("ROOT");
    }

    public TomcatSlf4jLogbackLoggerAccessor getLogger(String name) {
        try {
            Class<?> clazz = this.getTarget().getClass();
            Method getLogger = MethodUtils.getAccessibleMethod(clazz, (String)"getLogger", (Class[])new Class[]{String.class});
            Object logger = getLogger.invoke(this.getTarget(), name);
            if (logger == null) {
                throw new NullPointerException(this.getTarget() + ".getLogger(\"" + name + "\") returned null");
            }
            TomcatSlf4jLogbackLoggerAccessor accessor = new TomcatSlf4jLogbackLoggerAccessor();
            accessor.setTarget(logger);
            accessor.setApplication(this.getApplication());
            return accessor;
        }
        catch (Exception e) {
            logger.error("{}.getLogger('{}') failed", new Object[]{this.getTarget(), name, e});
            return null;
        }
    }

    public List<TomcatSlf4jLogbackAppenderAccessor> getAppenders() {
        ArrayList<TomcatSlf4jLogbackAppenderAccessor> appenders = new ArrayList<TomcatSlf4jLogbackAppenderAccessor>();
        try {
            Class<?> clazz = this.getTarget().getClass();
            Method getLoggerList = MethodUtils.getAccessibleMethod(clazz, (String)"getLoggerList", (Class[])new Class[0]);
            List loggers = (List)getLoggerList.invoke(this.getTarget(), new Object[0]);
            for (Object logger : loggers) {
                TomcatSlf4jLogbackLoggerAccessor accessor = new TomcatSlf4jLogbackLoggerAccessor();
                accessor.setTarget(logger);
                accessor.setApplication(this.getApplication());
                appenders.addAll(accessor.getAppenders());
            }
        }
        catch (Exception e) {
            logger.error("{}.getLoggerList() failed", this.getTarget(), (Object)e);
        }
        return appenders;
    }
}

