/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools.logging.logback;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.reflect.MethodUtils;
import psiprobe.tools.logging.DefaultAccessor;
import psiprobe.tools.logging.logback.LogbackAppenderAccessor;

public class LogbackLoggerAccessor
extends DefaultAccessor {
    public List<LogbackAppenderAccessor> getAppenders() {
        ArrayList<LogbackAppenderAccessor> appenders = new ArrayList<LogbackAppenderAccessor>();
        try {
            for (Object appender : Collections.list(Iterators.asEnumeration((Iterator)((Iterator)MethodUtils.invokeMethod((Object)this.getTarget(), (String)"iteratorForAppenders"))))) {
                List<Object> siftedAppenders = this.getSiftedAppenders(appender);
                if (siftedAppenders != null) {
                    for (Object siftedAppender : siftedAppenders) {
                        this.wrapAndAddAppender(siftedAppender, appenders);
                    }
                    continue;
                }
                this.wrapAndAddAppender(appender, appenders);
            }
        }
        catch (NoClassDefFoundError e) {
            logger.error("{}#getAppenders() failed", (Object)this.getTarget().getClass().getName(), (Object)e);
            logger.error("To see this logger, upgrade slf4j to 1.7.21+");
        }
        catch (Exception e) {
            logger.error("{}#getAppenders() failed", (Object)this.getTarget().getClass().getName(), (Object)e);
        }
        return appenders;
    }

    public LogbackAppenderAccessor getAppender(String name) {
        try {
            Object appender = MethodUtils.invokeMethod((Object)this.getTarget(), (String)"getAppender", (Object[])new Object[]{name});
            if (appender == null) {
                List<LogbackAppenderAccessor> appenders = this.getAppenders();
                for (LogbackAppenderAccessor wrappedAppender : appenders) {
                    if (!wrappedAppender.getIndex().equals(name)) continue;
                    return wrappedAppender;
                }
            }
            return this.wrapAppender(appender);
        }
        catch (Exception e) {
            logger.error("{}#getAppender() failed", (Object)this.getTarget().getClass().getName(), (Object)e);
            return null;
        }
    }

    public boolean isContext() {
        return false;
    }

    public boolean isRoot() {
        return "ROOT".equals(this.getName());
    }

    public String getName() {
        return (String)this.getProperty(this.getTarget(), "name", null);
    }

    public String getLevel() {
        try {
            Object level = MethodUtils.invokeMethod((Object)this.getTarget(), (String)"getLevel");
            return (String)MethodUtils.invokeMethod((Object)level, (String)"toString");
        }
        catch (Exception e) {
            logger.error("{}#getLevel() failed", (Object)this.getTarget().getClass().getName(), (Object)e);
            return null;
        }
    }

    public void setLevel(String newLevelStr) {
        try {
            Object level = MethodUtils.invokeMethod((Object)this.getTarget(), (String)"getLevel");
            Object newLevel = MethodUtils.invokeMethod((Object)level, (String)"toLevel", (Object[])new Object[]{newLevelStr});
            MethodUtils.invokeMethod((Object)this.getTarget(), (String)"setLevel", (Object[])new Object[]{newLevel});
        }
        catch (Exception e) {
            logger.error("{}#setLevel('{}') failed", new Object[]{this.getTarget().getClass().getName(), newLevelStr, e});
        }
    }

    private List<Object> getSiftedAppenders(Object appender) throws Exception {
        if ("ch.qos.logback.classic.sift.SiftingAppender".equals(appender.getClass().getName())) {
            Object tracker = MethodUtils.invokeMethod((Object)appender, (String)"getAppenderTracker");
            if (tracker != null) {
                try {
                    return (List)MethodUtils.invokeMethod((Object)tracker, (String)"allComponents");
                }
                catch (NoSuchMethodException e) {
                    logger.trace("", (Throwable)e);
                    return (List)MethodUtils.invokeMethod((Object)tracker, (String)"valueList");
                }
            }
            return new ArrayList<Object>();
        }
        return null;
    }

    private void wrapAndAddAppender(Object appender, List<LogbackAppenderAccessor> appenders) {
        LogbackAppenderAccessor appenderAccessor = this.wrapAppender(appender);
        if (appenderAccessor != null) {
            appenders.add(appenderAccessor);
        }
    }

    private LogbackAppenderAccessor wrapAppender(Object appender) {
        try {
            if (appender == null) {
                throw new IllegalArgumentException("appender is null");
            }
            LogbackAppenderAccessor appenderAccessor = new LogbackAppenderAccessor();
            appenderAccessor.setTarget(appender);
            appenderAccessor.setLoggerAccessor(this);
            appenderAccessor.setApplication(this.getApplication());
            return appenderAccessor;
        }
        catch (Exception e) {
            logger.error("Could not wrap appender: '{}'", appender, (Object)e);
            return null;
        }
    }
}

