/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools.logging.log4j2;

import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psiprobe.tools.logging.DefaultAccessor;
import psiprobe.tools.logging.log4j2.Log4J2LoggerContextAccessor;

public class Log4J2WebLoggerContextUtilsAccessor
extends DefaultAccessor {
    private static final Logger logger = LoggerFactory.getLogger(Log4J2WebLoggerContextUtilsAccessor.class);

    public Log4J2WebLoggerContextUtilsAccessor(ClassLoader cl) throws ClassNotFoundException {
        logger.debug("Log4J2WebLoggerContextUtilsAccessor(): IN: cl={}", (Object)cl);
        Class<?> clazz = cl.loadClass("org.apache.logging.log4j.web.WebLoggerContextUtils");
        this.setTarget(clazz);
        logger.debug("Log4J2WebLoggerContextUtilsAccessor(): OUT: this={}", (Object)this);
    }

    public Log4J2LoggerContextAccessor getWebLoggerContext(ServletContext ctx) {
        logger.debug("getWebLoggerContext(): IN: ctx={}", (Object)ctx);
        Log4J2LoggerContextAccessor result = null;
        try {
            Object loggerContext;
            Method getWebLoggerContext;
            Class clazz = (Class)this.getTarget();
            try {
                getWebLoggerContext = MethodUtils.getAccessibleMethod((Class)clazz, (String)"getWebLoggerContext", (Class[])new Class[]{ServletContext.class});
            }
            catch (Exception e) {
                logger.error("exception getting accessible method getWebLoggerContext", (Throwable)e);
                throw e;
            }
            try {
                loggerContext = getWebLoggerContext.invoke(null, ctx);
            }
            catch (Exception e) {
                logger.error("exception in getWebLoggerContext", (Throwable)e);
                throw e;
            }
            if (loggerContext == null) {
                throw new NullPointerException(this.getTarget().getClass().getName() + "#getWebLoggerContext(Ljavax/servlet/ServletContext) returned null");
            }
            result = new Log4J2LoggerContextAccessor();
            result.setTarget(loggerContext);
            result.setApplication(this.getApplication());
        }
        catch (Exception e) {
            logger.error("{}#getWebLoggerContext(Ljavax/servlet/ServletContext) failed", (Object)this.getTarget().getClass().getName(), (Object)e);
        }
        logger.debug("getWebLoggerContext(): OUT: result={}", result);
        return result;
    }
}

