/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools.logging;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psiprobe.model.Application;

public class DefaultAccessor {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultAccessor.class);
    private Application application;
    private Object target;

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public String getTargetClass() {
        return this.getTarget().getClass().getName();
    }

    protected Object getProperty(Object obj, String name, Object defaultValue, boolean forced) {
        try {
            if (forced) {
                return FieldUtils.readField((Object)obj, (String)name, (boolean)forced);
            }
            return PropertyUtils.isReadable((Object)obj, (String)name) ? PropertyUtils.getProperty((Object)obj, (String)name) : defaultValue;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("", (Throwable)e);
            logger.debug("Could not access property '{}' of object '{}'", (Object)name, obj);
            return defaultValue;
        }
    }

    protected Object getProperty(Object obj, String name, Object defaultValue) {
        return this.getProperty(obj, name, defaultValue, false);
    }

    protected Object invokeMethod(Object object, String name, Object param, Object defaultValue) {
        try {
            if (param == null) {
                return MethodUtils.invokeMethod((Object)object, (String)name);
            }
            return MethodUtils.invokeMethod((Object)object, (String)name, (Object[])new Object[]{param});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("", (Throwable)e);
            return defaultValue;
        }
    }
}

