/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools;

public final class TimeExpression {
    private TimeExpression() {
    }

    public static long dataPoints(String periodExpression, String spanExpression) {
        return TimeExpression.dataPoints(TimeExpression.inSeconds(periodExpression), TimeExpression.inSeconds(spanExpression));
    }

    public static long dataPoints(long period, long span) {
        if (period <= 0L) {
            return 0L;
        }
        return span / period;
    }

    public static String cronExpression(String periodExpression, String phaseExpression) {
        return TimeExpression.cronExpression(TimeExpression.inSeconds(periodExpression), TimeExpression.inSeconds(phaseExpression));
    }

    public static String cronExpression(long period, long phase) {
        while (phase >= period) {
            phase -= period;
        }
        long secondsPeriod = 0L;
        long minutesPeriod = 0L;
        long hoursPeriod = 0L;
        if (period < 60L) {
            secondsPeriod = period;
        } else if (period < 3600L) {
            minutesPeriod = period / 60L;
        } else if (period < 86400L) {
            hoursPeriod = period / 3600L;
        } else {
            throw new IllegalArgumentException("Period is too large: " + period);
        }
        long secondsPhase = 0L;
        long minutesPhase = 0L;
        long hoursPhase = 0L;
        if (phase < 60L) {
            secondsPhase = phase;
        } else if (phase < 3600L) {
            minutesPhase = phase / 60L;
        } else if (phase < 86400L) {
            hoursPhase = phase / 3600L;
        } else {
            throw new IllegalArgumentException("Phase is too large: " + phase);
        }
        String secondsCron = TimeExpression.cronSubexpression(secondsPeriod, secondsPhase);
        String minutesCron = "*";
        String hoursCron = "*";
        String daysCron = "*";
        String monthsCron = "*";
        String dowCron = "?";
        if (secondsPeriod == 0L) {
            minutesCron = TimeExpression.cronSubexpression(minutesPeriod, minutesPhase);
            if (minutesPeriod == 0L) {
                hoursCron = TimeExpression.cronSubexpression(hoursPeriod, hoursPhase);
            }
        }
        return secondsCron + " " + minutesCron + " " + hoursCron + " " + daysCron + " " + monthsCron + " " + dowCron;
    }

    private static String cronSubexpression(long period, long phase) {
        if (period == 0L) {
            return Long.toString(phase);
        }
        if (period == 1L && phase == 0L) {
            return "*";
        }
        return phase + "/" + period;
    }

    public static long inSeconds(String expression) {
        if (expression == null || expression.isEmpty()) {
            return 0L;
        }
        if (expression.matches("[0-9]+[smhd]")) {
            long multiplier = TimeExpression.multiplier(expression.charAt(expression.length() - 1));
            if (multiplier == 0L) {
                throw new IllegalArgumentException("Invalid unit in expression: " + expression);
            }
            long value = Integer.parseInt(expression.substring(0, expression.length() - 1));
            if (value < 0L) {
                throw new IllegalArgumentException("Invalid value in expression: " + expression);
            }
            return value * multiplier;
        }
        throw new IllegalArgumentException("Invalid expression format: " + expression);
    }

    private static int multiplier(char unit) {
        switch (unit) {
            case 's': {
                return 1;
            }
            case 'm': {
                return 60;
            }
            case 'h': {
                return 3600;
            }
        }
        throw new IllegalArgumentException("Invalid unit: " + unit);
    }
}

