/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools;

import java.text.NumberFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SizeExpression {
    public static final long MULTIPLIER_2 = 1024L;
    public static final long MULTIPLIER_10 = 1000L;
    public static final String UNIT_BASE = "B";
    public static final char PREFIX_KILO = 'K';
    public static final char PREFIX_MEGA = 'M';
    public static final char PREFIX_GIGA = 'G';
    public static final char PREFIX_TERA = 'T';
    public static final char PREFIX_PETA = 'P';

    private SizeExpression() {
    }

    public static long parse(String expression) {
        String prefixClass = "[KMGTP]";
        Pattern expPattern = Pattern.compile("(\\d+|\\d*\\.\\d+)\\s*(" + prefixClass + ")?(" + UNIT_BASE + ")?", 2);
        Matcher expMatcher = expPattern.matcher(expression);
        if (expMatcher.matches()) {
            String value = expMatcher.group(1);
            String unitPrefix = expMatcher.group(2);
            String unitBase = expMatcher.group(3);
            double multiplier = 1.0;
            if (unitPrefix != null) {
                multiplier = SizeExpression.multiplier(unitPrefix.charAt(0), unitBase != null);
            }
            double rawValue = Double.parseDouble(value);
            return (long)(rawValue * multiplier);
        }
        throw new NumberFormatException("Invalid expression format: " + expression);
    }

    public static String format(long value, int decimalPlaces, boolean base2) {
        double doubleResult;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumFractionDigits(decimalPlaces);
        String unit = base2 ? UNIT_BASE : "";
        double multiplierKilo = SizeExpression.multiplier('K', base2);
        double multiplierMega = SizeExpression.multiplier('M', base2);
        double multiplierGiga = SizeExpression.multiplier('G', base2);
        double multiplierTera = SizeExpression.multiplier('T', base2);
        double multiplierPeta = SizeExpression.multiplier('P', base2);
        if ((double)value < multiplierKilo) {
            doubleResult = value;
            nf.setMinimumFractionDigits(0);
        } else if ((double)value < multiplierMega) {
            doubleResult = SizeExpression.round((double)value / multiplierKilo, decimalPlaces);
            unit = 'K' + unit;
        } else if ((double)value < multiplierGiga) {
            doubleResult = SizeExpression.round((double)value / multiplierMega, decimalPlaces);
            unit = 'M' + unit;
        } else if ((double)value < multiplierTera) {
            doubleResult = SizeExpression.round((double)value / multiplierGiga, decimalPlaces);
            unit = 'G' + unit;
        } else if ((double)value < multiplierPeta) {
            doubleResult = SizeExpression.round((double)value / multiplierTera, decimalPlaces);
            unit = 'T' + unit;
        } else {
            doubleResult = SizeExpression.round((double)value / multiplierPeta, decimalPlaces);
            unit = 'P' + unit;
        }
        return nf.format(doubleResult) + (base2 ? " " : "") + unit;
    }

    private static double round(double value, int decimalPlaces) {
        return (double)Math.round(value * Math.pow(10.0, decimalPlaces)) / Math.pow(10.0, decimalPlaces);
    }

    private static double multiplier(char unitPrefix, boolean base2) {
        long result;
        long multiplier = base2 ? 1024L : 1000L;
        switch (Character.toUpperCase(unitPrefix)) {
            case 'K': {
                result = multiplier;
                break;
            }
            case 'M': {
                result = multiplier * multiplier;
                break;
            }
            case 'G': {
                result = multiplier * multiplier * multiplier;
                break;
            }
            case 'T': {
                result = multiplier * multiplier * multiplier * multiplier;
                break;
            }
            case 'P': {
                result = multiplier * multiplier * multiplier * multiplier * multiplier;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid unit prefix: " + unitPrefix);
            }
        }
        return result;
    }
}

