/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class BackwardsLineReader {
    private BufferedInputStream bis;
    private boolean skipLineFeed = true;
    private String encoding;

    public BackwardsLineReader(InputStream is) {
        this(is, null);
    }

    public BackwardsLineReader(InputStream is, String encoding) {
        this.bis = new BufferedInputStream(is, 8192);
        this.encoding = encoding;
    }

    public String readLine() throws IOException {
        boolean empty;
        ByteArrayOutputStream baos;
        block5: {
            byte chr;
            baos = new ByteArrayOutputStream(512);
            empty = false;
            while ((chr = (byte)this.bis.read()) != -1) {
                if (chr == 10) {
                    this.skipLineFeed = false;
                    break block5;
                }
                if (chr == 13) {
                    if (!this.skipLineFeed) continue;
                    break block5;
                }
                baos.write(chr);
            }
            if (baos.toByteArray().length == 0) {
                empty = true;
            }
        }
        if (!empty) {
            byte[] byteArray = baos.toByteArray();
            this.reverse(byteArray);
            return this.encoding == null ? new String(byteArray, StandardCharsets.UTF_8) : new String(byteArray, Charset.forName(this.encoding));
        }
        return null;
    }

    public void close() throws IOException {
        if (this.bis != null) {
            this.bis.close();
        }
    }

    private void reverse(byte[] byteArray) {
        for (int i = 0; i < byteArray.length / 2; ++i) {
            byte temp = byteArray[i];
            byteArray[i] = byteArray[byteArray.length - i - 1];
            byteArray[byteArray.length - i - 1] = temp;
        }
    }
}

