/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools;

import java.io.IOException;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psiprobe.tools.TimeoutException;

public final class AsyncSocketFactory {
    private static final Logger logger = LoggerFactory.getLogger(AsyncSocketFactory.class);

    private AsyncSocketFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Socket createSocket(String server, int port, long timeout) throws IOException {
        SocketWrapper socketWrapper = new SocketWrapper();
        socketWrapper.server = server;
        socketWrapper.port = port;
        Object sync = new Object();
        Thread socketThread = new Thread(new SocketRunnable(socketWrapper, sync));
        socketThread.setDaemon(true);
        Thread timeoutThread = new Thread(new TimeoutRunnable(sync, timeout * 1000L));
        timeoutThread.setDaemon(true);
        timeoutThread.start();
        socketThread.start();
        Object object = sync;
        synchronized (object) {
            if (socketWrapper.socket == null) {
                try {
                    sync.wait(timeout * 1000L);
                }
                catch (InterruptedException e) {
                    logger.trace("", (Throwable)e);
                }
            }
        }
        timeoutThread.interrupt();
        socketThread.interrupt();
        socketWrapper.valid = false;
        if (socketWrapper.getSocket() == null && socketWrapper.exception != null) {
            throw socketWrapper.exception;
        }
        if (socketWrapper.getSocket() == null) {
            throw new TimeoutException();
        }
        return socketWrapper.getSocket();
    }

    static class SocketWrapper {
        Socket socket;
        String server;
        int port;
        IOException exception;
        boolean valid = true;

        SocketWrapper() {
        }

        public Socket getSocket() {
            return this.socket;
        }

        public void setSocket(Socket socket) {
            this.socket = socket;
        }

        public String getServer() {
            return this.server;
        }

        public int getPort() {
            return this.port;
        }

        public void setException(IOException exception) {
            this.exception = exception;
        }

        public boolean isValid() {
            return this.valid;
        }
    }

    static class SocketRunnable
    implements Runnable {
        private final SocketWrapper socketWrapper;
        private final Object sync;

        public SocketRunnable(SocketWrapper socketWrapper, Object sync) {
            this.socketWrapper = socketWrapper;
            this.sync = sync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (Socket socket = new Socket(this.socketWrapper.getServer(), this.socketWrapper.getPort());){
                this.socketWrapper.setSocket(socket);
                if (!this.socketWrapper.isValid()) {
                    this.socketWrapper.getSocket().close();
                    this.socketWrapper.setSocket(null);
                }
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
                this.socketWrapper.setException(e);
            }
            Object object = this.sync;
            synchronized (object) {
                this.sync.notify();
            }
        }
    }

    static class TimeoutRunnable
    implements Runnable {
        private final Object sync;
        private final long timeout;

        public TimeoutRunnable(Object sync, long timeout) {
            this.sync = sync;
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(this.timeout);
                Object object = this.sync;
                synchronized (object) {
                    this.sync.notify();
                }
            }
            catch (InterruptedException e) {
                logger.trace("", (Throwable)e);
            }
        }
    }
}

