/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.model.stats;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import org.jfree.data.xy.XYDataItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;
import psiprobe.tools.UpdateCommitLock;

public class StatsCollection
implements InitializingBean,
DisposableBean,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(StatsCollection.class);
    private Map<String, List<XYDataItem>> statsData = new TreeMap<String, List<XYDataItem>>();
    @Inject
    private XStream xstream;
    private String swapFileName;
    private String storagePath;
    private File contextTempDir;
    private int maxFiles = 2;
    private final UpdateCommitLock lock = new UpdateCommitLock();

    public String getSwapFileName() {
        return this.swapFileName;
    }

    @Value(value="stats.xml")
    public void setSwapFileName(String swapFileName) {
        this.swapFileName = swapFileName;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }

    public synchronized boolean isCollected(String statsName) {
        return this.statsData.get(statsName) != null;
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public void setMaxFiles(int maxFiles) {
        this.maxFiles = maxFiles > 0 ? maxFiles : 2;
    }

    public synchronized List<XYDataItem> newStats(String name, int maxElements) {
        List<XYDataItem> stats = Collections.synchronizedList(new ArrayList(maxElements));
        this.statsData.put(name, stats);
        return stats;
    }

    public synchronized void resetStats(String name) {
        List<XYDataItem> stats = this.getStats(name);
        if (stats != null) {
            stats.clear();
        }
    }

    public synchronized List<XYDataItem> getStats(String name) {
        return this.statsData.get(name);
    }

    public long getLastValueForStat(String statName) {
        XYDataItem xy;
        long statValue = 0L;
        List<XYDataItem> stats = this.getStats(statName);
        if (stats != null && !stats.isEmpty() && (xy = stats.get(stats.size() - 1)) != null && xy.getY() != null) {
            statValue = xy.getY().longValue();
        }
        return statValue;
    }

    public synchronized Map<String, List<XYDataItem>> getStatsByPrefix(String statNamePrefix) {
        HashMap<String, List<XYDataItem>> map = new HashMap<String, List<XYDataItem>>();
        for (Map.Entry<String, List<XYDataItem>> en : this.statsData.entrySet()) {
            if (!en.getKey().startsWith(statNamePrefix)) continue;
            map.put(en.getKey(), en.getValue());
        }
        return map;
    }

    private File makeFile() {
        return this.storagePath == null ? new File(this.contextTempDir, this.swapFileName) : new File(this.storagePath, this.swapFileName);
    }

    private void shiftFiles(int index) {
        if (index >= this.maxFiles - 1) {
            try {
                if (Files.exists(Paths.get(this.makeFile().getAbsolutePath() + "." + index, new String[0]), new LinkOption[0])) {
                    Files.delete(Paths.get(this.makeFile().getAbsolutePath() + "." + index, new String[0]));
                }
            }
            catch (IOException e) {
                logger.error("Could not delete file {}", (Object)new File(this.makeFile().getAbsolutePath() + "." + index).getName());
            }
        } else {
            File destFile;
            File srcFile;
            this.shiftFiles(index + 1);
            File file = srcFile = index == 0 ? this.makeFile() : new File(this.makeFile().getAbsolutePath() + "." + index);
            if (Files.exists(srcFile.toPath(), new LinkOption[0]) && !srcFile.renameTo(destFile = new File(this.makeFile().getAbsolutePath() + "." + (index + 1)))) {
                logger.error("Could not rename file {} to {}", (Object)srcFile.getName(), (Object)destFile.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void serialize() throws InterruptedException {
        this.lock.lockForCommit();
        long start = System.currentTimeMillis();
        try {
            this.shiftFiles(0);
            try (OutputStream os = Files.newOutputStream(this.makeFile().toPath(), new OpenOption[0]);){
                this.xstream.toXML(this.statsData, os);
            }
        }
        catch (Exception e) {
            logger.error("Could not write stats data to '{}'", (Object)this.makeFile().getAbsolutePath(), (Object)e);
        }
        finally {
            this.lock.releaseCommitLock();
            logger.debug("stats serialized in {}ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    private Map<String, List<XYDataItem>> deserialize(File file) {
        Map stats = null;
        if (file.exists() && file.canRead()) {
            long start = System.currentTimeMillis();
            try {
                try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                    stats = (Map)this.xstream.fromXML(fis);
                    if (stats != null) {
                        for (Map.Entry set : stats.entrySet()) {
                            List list = (List)set.getValue();
                            if (list.isEmpty()) continue;
                            XYDataItem xy = (XYDataItem)list.get(list.size() - 1);
                            list.add(new XYDataItem((double)(xy.getX().longValue() + 1L), 0.0));
                            list.add(new XYDataItem((double)System.currentTimeMillis(), 0.0));
                        }
                    }
                }
                logger.debug("stats data read in {}ms", (Object)(System.currentTimeMillis() - start));
            }
            catch (Exception e) {
                logger.error("Could not read stats data from '{}'", (Object)file.getAbsolutePath(), (Object)e);
            }
        }
        return stats;
    }

    public void lockForUpdate() throws InterruptedException {
        this.lock.lockForUpdate();
    }

    public void releaseLock() {
        this.lock.releaseUpdateLock();
    }

    public synchronized void afterPropertiesSet() {
        File file;
        Map<String, List<XYDataItem>> stats;
        int index = 0;
        while ((stats = this.deserialize(file = index == 0 ? this.makeFile() : new File(this.makeFile().getAbsolutePath() + "." + index))) == null && ++index < this.maxFiles - 1) {
        }
        if (stats != null) {
            this.statsData = stats;
        } else {
            logger.debug("Stats data file not found. Empty file assumed.");
        }
    }

    public void destroy() throws Exception {
        this.serialize();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        WebApplicationContext wac = (WebApplicationContext)applicationContext;
        this.contextTempDir = (File)wac.getServletContext().getAttribute("javax.servlet.context.tempdir");
    }
}

