/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.model;

import javax.servlet.http.HttpServletRequest;

public class IpInfo {
    private String address;
    private boolean forwarded;

    public IpInfo builder(HttpServletRequest request) {
        this.address = IpInfo.getClientAddress(request);
        if (!this.address.equals(request.getRemoteAddr())) {
            this.forwarded = true;
        }
        return this;
    }

    public boolean isForwarded() {
        return this.forwarded;
    }

    public void setForwarded(boolean forwarded) {
        this.forwarded = forwarded;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String toString() {
        return this.address;
    }

    public static String getClientAddress(HttpServletRequest request) {
        String addr = request.getRemoteAddr();
        String fwdHeader = request.getHeader("X-Forwarded-For");
        if (fwdHeader != null) {
            addr = fwdHeader.split(",")[0];
        }
        return addr;
    }
}

