/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.model;

import psiprobe.model.DataSourceInfo;

public class DataSourceInfoGroup
extends DataSourceInfo {
    private int dataSourceCount;

    public DataSourceInfoGroup() {
        this.setJdbcUrl(null);
        this.setBusyConnections(0);
        this.setEstablishedConnections(0);
        this.setMaxConnections(0);
    }

    public DataSourceInfoGroup builder(DataSourceInfo dataSourceInfo) {
        this.setJdbcUrl(dataSourceInfo.getJdbcUrl());
        this.setBusyConnections(dataSourceInfo.getBusyConnections());
        this.setEstablishedConnections(dataSourceInfo.getEstablishedConnections());
        this.setMaxConnections(dataSourceInfo.getMaxConnections());
        this.setDataSourceCount(1);
        return this;
    }

    public int getDataSourceCount() {
        return this.dataSourceCount;
    }

    public void setDataSourceCount(int dataSourceCount) {
        this.dataSourceCount = dataSourceCount;
    }

    public void addBusyConnections(int busyConnectionsDelta) {
        this.setBusyConnections(this.getBusyConnections() + busyConnectionsDelta);
    }

    public void addEstablishedConnections(int establishedConnectionsDelta) {
        this.setEstablishedConnections(this.getEstablishedConnections() + establishedConnectionsDelta);
    }

    public void addMaxConnections(int maxConnectionsDelta) {
        this.setMaxConnections(this.getMaxConnections() + maxConnectionsDelta);
    }

    public void addDataSourceCount(int dataSourceCountDelta) {
        this.setDataSourceCount(this.getDataSourceCount() + dataSourceCountDelta);
    }

    public void addDataSourceInfo(DataSourceInfo dataSourceInfoDelta) {
        this.addBusyConnections(dataSourceInfoDelta.getBusyConnections());
        this.addEstablishedConnections(dataSourceInfoDelta.getEstablishedConnections());
        this.addMaxConnections(dataSourceInfoDelta.getMaxConnections());
        this.addDataSourceCount(1);
    }
}

