/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import psiprobe.model.Attribute;

public class ApplicationSession {
    public static final String LAST_ACCESSED_BY_IP = "__psiprobe_la_ip";
    public static final String LAST_ACCESSED_LOCALE = "__psiprobe_la_local";
    private String id;
    private String applicationName;
    private Date creationTime;
    private Date lastAccessTime;
    private int maxIdleTime;
    private boolean valid;
    private boolean serializable;
    private long objectCount;
    private String info;
    private String managerType;
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private long size;
    private boolean allowedToViewValues;
    private String lastAccessedIp;
    private Locale lastAccessedIpLocale;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public Date getCreationTime() {
        return this.creationTime == null ? null : new Date(this.creationTime.getTime());
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime == null ? null : new Date(creationTime.getTime());
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime == null ? null : new Date(this.lastAccessTime.getTime());
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime == null ? null : new Date(lastAccessTime.getTime());
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public long getObjectCount() {
        return this.objectCount;
    }

    public void setObjectCount(long objectCount) {
        this.objectCount = objectCount;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(Attribute sa) {
        this.attributes.add(sa);
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getManagerType() {
        return this.managerType;
    }

    public void setManagerType(String managerType) {
        this.managerType = managerType;
    }

    public long getAge() {
        if (this.creationTime == null) {
            return 0L;
        }
        return System.currentTimeMillis() - this.creationTime.getTime();
    }

    public long getIdleTime() {
        if (this.lastAccessTime == null) {
            return this.getAge();
        }
        return System.currentTimeMillis() - this.lastAccessTime.getTime();
    }

    public Date getExpiryTime() {
        if (this.getMaxIdleTime() <= 0) {
            return null;
        }
        return new Date(System.currentTimeMillis() + (long)this.getMaxIdleTime() - this.getIdleTime());
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public void setSerializable(boolean serializable) {
        this.serializable = serializable;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean isAllowedToViewValues() {
        return this.allowedToViewValues;
    }

    public void setAllowedToViewValues(boolean allowedToViewValues) {
        this.allowedToViewValues = allowedToViewValues;
    }

    public String getLastAccessedIp() {
        return this.lastAccessedIp;
    }

    public void setLastAccessedIp(String lastAccessedIp) {
        this.lastAccessedIp = lastAccessedIp;
    }

    public Locale getLastAccessedIpLocale() {
        return this.lastAccessedIpLocale;
    }

    public void setLastAccessedIpLocale(Locale lastAccessedIpLocale) {
        this.lastAccessedIpLocale = lastAccessedIpLocale;
    }
}

