/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.jsp;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psiprobe.tools.SizeExpression;

public class VolumeTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(VolumeTag.class);
    private long value;
    private int fractions;

    public void setValue(long value) {
        this.value = value;
    }

    public int getFractions() {
        return this.fractions;
    }

    public void setFractions(int fractions) {
        this.fractions = fractions;
    }

    public int doStartTag() throws JspException {
        String title = Long.toString(this.value);
        String newValue = SizeExpression.format(this.value, this.fractions, true);
        try {
            this.pageContext.getOut().write("<span title=\"" + title + "\">" + newValue + "</span>");
        }
        catch (IOException e) {
            logger.debug("Exception writing value to JspWriter", (Throwable)e);
            throw new JspException((Throwable)e);
        }
        return 1;
    }
}

