/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.jsp;

import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualScoreTag
extends BodyTagSupport {
    private static final long serialVersionUID = -5653846466205838602L;
    private static final Logger logger = LoggerFactory.getLogger(VisualScoreTag.class);
    private static final String WHITE_LEFT_BORDER = "a0";
    private static final String RED_LEFT_BORDER = "a1";
    private static final String BLUE_LEFT_BORDER = "a2";
    private static final String WHITE_RIGHT_BORDER = "b0";
    private static final String RED_RIGHT_BORDER = "b1";
    private static final String BLUE_RIGHT_BORDER = "b2";
    private double value = 0.0;
    private double value2 = 0.0;
    private double minValue = 0.0;
    private double maxValue = 100.0;
    private int partialBlocks = 1;
    private int fullBlocks = 5;
    private boolean showEmptyBlocks;
    private boolean showA;
    private boolean showB;

    public int doAfterBody() throws JspException {
        try (BodyContent bc = this.getBodyContent();){
            String body = bc.getString().trim();
            String buf = this.calculateSuffix(body);
            bc.getEnclosingWriter().print(buf);
        }
        catch (IOException e) {
            logger.trace("", (Throwable)e);
            throw new JspException("Error:IOException while writing to client" + e.getMessage());
        }
        return 0;
    }

    String calculateSuffix(String body) {
        int emptyBlocks;
        double unitSize;
        double blockWidth;
        int redWhole;
        int redPart;
        if (this.value < this.minValue) {
            this.value = this.minValue;
        }
        if (this.value > this.maxValue) {
            this.value = this.maxValue;
        }
        if (this.value + this.value2 < this.minValue || this.value2 < 0.0) {
            this.value2 = 0.0;
        }
        if (this.value + this.value2 > this.maxValue) {
            this.value2 = this.maxValue - this.value;
        }
        int bluePart1 = (redPart = (int)Math.floor((this.value - (double)(redWhole = (int)Math.floor(this.value / (blockWidth = (unitSize = (this.maxValue - this.minValue) / (double)(this.fullBlocks * this.partialBlocks)) * (double)this.partialBlocks))) * blockWidth) / unitSize)) > 0 ? Math.min((int)Math.floor(this.value2 / unitSize), this.partialBlocks - redPart) : 0;
        int blueWhole = (int)Math.max(0.0, Math.ceil(this.value2 / blockWidth) - (double)(redPart > 0 ? 1 : 0));
        int bluePart2 = (int)Math.floor((this.value2 - (double)blueWhole * blockWidth - (double)bluePart1 * unitSize) / unitSize);
        StringBuilder buf = new StringBuilder();
        if (this.showA) {
            String format = WHITE_LEFT_BORDER;
            if (redWhole > 0 || redPart > 0) {
                format = RED_LEFT_BORDER;
            } else if (bluePart1 == 0 && (blueWhole > 0 || bluePart2 > 0)) {
                format = BLUE_LEFT_BORDER;
            }
            buf.append(MessageFormat.format(body, format));
        }
        String fullRedBody = MessageFormat.format(body, this.partialBlocks + "+0");
        for (int i = 0; i < redWhole; ++i) {
            buf.append(fullRedBody);
        }
        if (redPart > 0) {
            String partialBody = MessageFormat.format(body, redPart + "+" + bluePart1);
            buf.append(partialBody);
        }
        String fullBlueBody = MessageFormat.format(body, "0+" + this.partialBlocks);
        for (int i = 0; i < blueWhole; ++i) {
            buf.append(fullBlueBody);
        }
        if (bluePart2 > 0) {
            String partialBody = MessageFormat.format(body, "0+" + bluePart2);
            buf.append(partialBody);
        }
        int n = this.showEmptyBlocks ? this.fullBlocks - (redWhole + blueWhole + (redPart > 0 ? 1 : 0) + (bluePart2 > 0 ? 1 : 0)) : (emptyBlocks = 0);
        if (emptyBlocks > 0) {
            String emptyBody = MessageFormat.format(body, "0+0");
            for (int i = 0; i < emptyBlocks; ++i) {
                buf.append(emptyBody);
            }
        }
        if (this.showB) {
            String format = WHITE_RIGHT_BORDER;
            if (redWhole == this.fullBlocks) {
                format = RED_RIGHT_BORDER;
            } else if (redWhole + (redPart + bluePart1 == this.partialBlocks ? 1 : 0) + blueWhole == this.fullBlocks) {
                format = BLUE_RIGHT_BORDER;
            }
            buf.append(MessageFormat.format(body, format));
        }
        return buf.toString();
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getValue2() {
        return this.value2;
    }

    public void setValue2(double value2) {
        this.value2 = value2;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public int getPartialBlocks() {
        return this.partialBlocks;
    }

    public void setPartialBlocks(int partialBlocks) {
        this.partialBlocks = partialBlocks;
    }

    public int getFullBlocks() {
        return this.fullBlocks;
    }

    public void setFullBlocks(int fullBlocks) {
        this.fullBlocks = fullBlocks;
    }

    public boolean isShowEmptyBlocks() {
        return this.showEmptyBlocks;
    }

    public void setShowEmptyBlocks(boolean showEmptyBlocks) {
        this.showEmptyBlocks = showEmptyBlocks;
    }

    public boolean isShowA() {
        return this.showA;
    }

    public void setShowA(boolean showA) {
        this.showA = showA;
    }

    public boolean isShowB() {
        return this.showB;
    }

    public void setShowB(boolean showB) {
        this.showB = showB;
    }
}

