/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.jsp;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.text.StringEscapeUtils;

public class OutTag
extends BodyTagSupport {
    private static final long serialVersionUID = 1L;
    private int maxLength = -1;
    private boolean ellipsisRight = true;
    private Object value;

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public boolean isEllipsisRight() {
        return this.ellipsisRight;
    }

    public void setEllipsisRight(boolean ellipsisRight) {
        this.ellipsisRight = ellipsisRight;
    }

    public int doStartTag() throws JspException {
        if (this.value != null) {
            this.print(this.value.toString(), this.pageContext.getOut());
            return 0;
        }
        return super.doStartTag();
    }

    public int doAfterBody() throws JspException {
        this.print(this.getBodyContent().getString().trim(), this.getBodyContent().getEnclosingWriter());
        return 0;
    }

    private void print(String displayValue, JspWriter out) throws JspException {
        try {
            if (this.maxLength != -1 && displayValue.length() > this.maxLength) {
                String newValue = this.ellipsisRight ? displayValue.substring(0, this.maxLength - 3) + "..." : "..." + displayValue.substring(displayValue.length() - this.maxLength + 3);
                String title = StringEscapeUtils.escapeHtml4((String)displayValue);
                out.print("<span title=\"" + title + "\">" + newValue + "</span>");
            } else {
                out.print(displayValue);
            }
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }
}

