/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.jsp;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurationTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DurationTag.class);
    private long value;

    public void setValue(long value) {
        this.value = value;
    }

    public int doStartTag() throws JspException {
        try {
            this.pageContext.getOut().write(DurationTag.duration(this.value));
        }
        catch (IOException e) {
            logger.debug("Exception writing duration to JspWriter", (Throwable)e);
            throw new JspException((Throwable)e);
        }
        return 1;
    }

    public static String duration(long value) {
        long millis = value % 1000L;
        long sec = value / 1000L;
        long mins = sec / 60L;
        long hours = mins / 60L;
        return hours + ":" + DurationTag.long2Str(mins %= 60L) + ":" + DurationTag.long2Str(sec %= 60L) + "." + DurationTag.long3Str(millis);
    }

    private static String long2Str(long value) {
        return value < 10L ? "0" + value : Long.toString(value);
    }

    private static String long3Str(long value) {
        if (value < 10L) {
            return "00" + value;
        }
        if (value < 100L) {
            return "0" + value;
        }
        return Long.toString(value);
    }
}

