/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.wrapper;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.ParameterizableViewController;
import org.tanukisoftware.wrapper.WrapperManager;
import psiprobe.model.wrapper.WrapperInfo;

@Controller
public class WrapperInfoController
extends ParameterizableViewController {
    private static final Logger logger = LoggerFactory.getLogger(WrapperInfoController.class);

    @RequestMapping(path={"/wrapper.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        WrapperInfo wi = new WrapperInfo();
        try {
            Class.forName("org.tanukisoftware.wrapper.WrapperManager");
            wi.setVersion(WrapperManager.getVersion());
            wi.setBuildTime(WrapperManager.getBuildTime());
            wi.setUser(WrapperManager.getUser((boolean)false) != null ? WrapperManager.getUser((boolean)false).getUser() : null);
            wi.setInteractiveUser(WrapperManager.getInteractiveUser((boolean)false) != null ? WrapperManager.getInteractiveUser((boolean)false).getUser() : null);
            wi.setJvmPid(WrapperManager.getJavaPID());
            wi.setWrapperPid(WrapperManager.getWrapperPID());
            wi.setProperties(WrapperManager.getProperties().entrySet());
            wi.setControlledByWrapper(WrapperManager.isControlledByNativeWrapper());
            wi.setDebugEnabled(WrapperManager.isDebugEnabled());
            wi.setLaunchedAsService(WrapperManager.isLaunchedAsService());
        }
        catch (ClassNotFoundException e) {
            logger.info("Could not find WrapperManager class. Is wrapper.jar in the classpath?");
            logger.trace("", (Throwable)e);
            wi.setControlledByWrapper(false);
        }
        return new ModelAndView(this.getViewName(), "wrapperInfo", (Object)wi);
    }

    @Value(value="wrapper")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

