/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.truststore;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.controllers.AbstractTomcatContainerController;

@Controller
public class TrustStoreController
extends AbstractTomcatContainerController {
    private static final Logger logger = LoggerFactory.getLogger(TrustStoreController.class);

    @RequestMapping(path={"/truststore.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList certificateList;
        block11: {
            certificateList = new ArrayList();
            try {
                String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType");
                KeyStore ks = trustStoreType != null ? KeyStore.getInstance(trustStoreType) : KeyStore.getInstance("JKS");
                String trustStore = System.getProperty("javax.net.ssl.trustStore");
                String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
                if (trustStore == null) break block11;
                try (InputStream fis = Files.newInputStream(Paths.get(trustStore, new String[0]), new OpenOption[0]);){
                    ks.load(fis, trustStorePassword != null ? trustStorePassword.toCharArray() : null);
                }
                catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                    logger.error("", (Throwable)e);
                }
                for (String alias : Collections.list(ks.aliases())) {
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    if (!"X.509".equals(ks.getCertificate(alias).getType())) continue;
                    X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
                    attributes.put("alias", alias);
                    attributes.put("cn", cert.getSubjectDN().toString());
                    attributes.put("expirationDate", new SimpleDateFormat("yyyy-MM-dd").format(cert.getNotAfter()));
                    certificateList.add(attributes);
                }
            }
            catch (KeyStoreException e) {
                logger.error("There was an exception obtaining truststore: ", (Throwable)e);
            }
        }
        ModelAndView mv = new ModelAndView(this.getViewName());
        mv.addObject("certificates", certificateList);
        return mv;
    }

    @Override
    @Value(value="truststore")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

