/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.threads;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.ParameterizableViewController;
import psiprobe.model.ThreadStackElement;
import psiprobe.tools.JmxTools;

@Controller
public class ThreadStackController
extends ParameterizableViewController {
    private int stackElementCount = 20;

    public int getStackElementCount() {
        return this.stackElementCount;
    }

    @Value(value="100")
    public void setStackElementCount(int stackElementCount) {
        this.stackElementCount = stackElementCount;
    }

    @RequestMapping(path={"/app/threadstack.ajax"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        CompositeData cd;
        long threadId = ServletRequestUtils.getLongParameter((ServletRequest)request, (String)"id", (long)-1L);
        String threadName = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"name", null);
        ArrayList<ThreadStackElement> stack = null;
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName threadingOName = new ObjectName("java.lang:type=Threading");
        if (threadId == -1L && threadName != null) {
            for (long id : (long[])mbeanServer.getAttribute(threadingOName, "AllThreadIds")) {
                CompositeData cd2 = (CompositeData)mbeanServer.invoke(threadingOName, "getThreadInfo", new Object[]{id}, new String[]{"long"});
                String name = JmxTools.getStringAttr(cd2, "threadName");
                if (!threadName.equals(name)) continue;
                threadId = id;
                break;
            }
        }
        if (mbeanServer.queryMBeans(threadingOName, null) != null && threadId != -1L && (cd = (CompositeData)mbeanServer.invoke(threadingOName, "getThreadInfo", new Object[]{threadId, this.stackElementCount}, new String[]{"long", "int"})) != null) {
            CompositeData[] elements = (CompositeData[])cd.get("stackTrace");
            threadName = JmxTools.getStringAttr(cd, "threadName");
            stack = new ArrayList<ThreadStackElement>(elements.length);
            for (CompositeData cd2 : elements) {
                ThreadStackElement tse = new ThreadStackElement();
                tse.setClassName(JmxTools.getStringAttr(cd2, "className"));
                tse.setFileName(JmxTools.getStringAttr(cd2, "fileName"));
                tse.setMethodName(JmxTools.getStringAttr(cd2, "methodName"));
                tse.setLineNumber(JmxTools.getIntAttr(cd2, "lineNumber", -1));
                tse.setNativeMethod(JmxTools.getBooleanAttr(cd2, "nativeMethod"));
                stack.add(tse);
            }
        }
        return new ModelAndView(this.getViewName(), "stack", stack).addObject("threadName", (Object)threadName);
    }

    @Value(value="ajax/ThreadStack")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

