/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.system;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.beans.RuntimeInfoAccessorBean;
import psiprobe.controllers.AbstractTomcatContainerController;
import psiprobe.model.SystemInformation;
import psiprobe.tools.SecurityUtils;

public class BaseSysInfoController
extends AbstractTomcatContainerController {
    private List<String> filterOutKeys = new ArrayList<String>();
    @Inject
    private RuntimeInfoAccessorBean runtimeInfoAccessor;
    private long collectionPeriod;

    public List<String> getFilterOutKeys() {
        return this.filterOutKeys;
    }

    public void setFilterOutKeys(List<String> filterOutKeys) {
        this.filterOutKeys = filterOutKeys;
    }

    public RuntimeInfoAccessorBean getRuntimeInfoAccessor() {
        return this.runtimeInfoAccessor;
    }

    public void setRuntimeInfoAccessor(RuntimeInfoAccessorBean runtimeInfoAccessor) {
        this.runtimeInfoAccessor = runtimeInfoAccessor;
    }

    public long getCollectionPeriod() {
        return this.collectionPeriod;
    }

    public void setCollectionPeriod(long collectionPeriod) {
        this.collectionPeriod = collectionPeriod;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        SystemInformation systemInformation = new SystemInformation();
        systemInformation.setAppBase(this.getContainerWrapper().getTomcatContainer().getAppBase().getAbsolutePath());
        systemInformation.setConfigBase(this.getContainerWrapper().getTomcatContainer().getConfigBase());
        HashMap<String, String> sysProps = new HashMap<String, String>();
        for (String propertyName : System.getProperties().stringPropertyNames()) {
            String propertyValue = System.getProperty(propertyName);
            sysProps.put(propertyName, propertyValue);
        }
        if (!SecurityUtils.hasAttributeValueRole(this.getServletContext(), request)) {
            for (String key : this.filterOutKeys) {
                sysProps.remove(key);
            }
        }
        systemInformation.setSystemProperties(sysProps);
        ModelAndView mv = new ModelAndView(this.getViewName());
        mv.addObject("systemInformation", (Object)systemInformation);
        mv.addObject("runtime", (Object)this.getRuntimeInfoAccessor().getRuntimeInformation());
        mv.addObject("collectionPeriod", (Object)this.getCollectionPeriod());
        return mv;
    }
}

