/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.system;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.ParameterizableViewController;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class AdviseGarbageCollectionController
extends ParameterizableViewController {
    private static final Logger logger = LoggerFactory.getLogger(AdviseGarbageCollectionController.class);
    private String replacePattern;

    public String getReplacePattern() {
        return this.replacePattern;
    }

    @Value(value="^http(s)?://[a-zA-Z\\-\\.0-9]+(:[0-9]+)?")
    public void setReplacePattern(String replacePattern) {
        this.replacePattern = replacePattern;
    }

    @RequestMapping(path={"/adm/advisegc.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean finalization = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"fin", (boolean)false);
        String referer = request.getHeader("Referer");
        String redirectUrl = referer != null ? referer.replaceAll(this.replacePattern, "") : request.getContextPath() + this.getViewName();
        if (finalization) {
            Runtime.getRuntime().runFinalization();
            logger.debug("Advised finalization");
        } else {
            Runtime.getRuntime().gc();
            logger.debug("Advised Garbage Collection");
        }
        logger.debug("Redirected to {}", (Object)redirectUrl);
        return new ModelAndView((View)new RedirectView(redirectUrl));
    }

    @Value(value="/sysinfo.htm")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

