/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.catalina.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import psiprobe.controllers.AbstractContextHandlerController;
import psiprobe.model.sql.DataSourceTestInfo;

@Controller
public class ExecuteSqlController
extends AbstractContextHandlerController {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteSqlController.class);

    @RequestMapping(path={"/sql/recordset.ajax"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ModelAndView handleContext(String contextName, Context context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String resourceName = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"resource");
        String sql = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"sql", null);
        if (sql == null || sql.isEmpty() || sql.trim().isEmpty()) {
            request.setAttribute("errorMessage", (Object)this.getMessageSourceAccessor().getMessage("probe.src.dataSourceTest.sql.required"));
            return new ModelAndView(this.getViewName());
        }
        int maxRows = ServletRequestUtils.getIntParameter((ServletRequest)request, (String)"maxRows", (int)0);
        int rowsPerPage = ServletRequestUtils.getIntParameter((ServletRequest)request, (String)"rowsPerPage", (int)0);
        int historySize = ServletRequestUtils.getIntParameter((ServletRequest)request, (String)"historySize", (int)0);
        HttpSession sess = request.getSession(false);
        DataSourceTestInfo sessData = (DataSourceTestInfo)sess.getAttribute("dataSourceTestData");
        HttpSession httpSession = sess;
        synchronized (httpSession) {
            if (sessData == null) {
                sessData = new DataSourceTestInfo();
                sess.setAttribute("dataSourceTestData", (Object)sessData);
            }
            sessData.setMaxRows(maxRows);
            sessData.setRowsPerPage(rowsPerPage);
            sessData.setHistorySize(historySize);
            sessData.addQueryToHistory(sql);
        }
        DataSource dataSource = null;
        try {
            dataSource = this.getContainerWrapper().getResourceResolver().lookupDataSource(context, resourceName, this.getContainerWrapper());
        }
        catch (NamingException e) {
            request.setAttribute("errorMessage", (Object)this.getMessageSourceAccessor().getMessage("probe.src.dataSourceTest.resource.lookup.failure", new Object[]{resourceName}));
            logger.trace("", (Throwable)e);
        }
        if (dataSource == null) {
            request.setAttribute("errorMessage", (Object)this.getMessageSourceAccessor().getMessage("probe.src.dataSourceTest.resource.lookup.failure", new Object[]{resourceName}));
        } else {
            ArrayList<Map<String, String>> results = null;
            int rowsAffected = 0;
            try {
                Connection conn;
                block37: {
                    conn = dataSource.getConnection();
                    try {
                        conn.setAutoCommit(true);
                        try (PreparedStatement stmt = conn.prepareStatement(sql);){
                            boolean hasResultSet = stmt.execute();
                            if (!hasResultSet) {
                                rowsAffected = stmt.getUpdateCount();
                                break block37;
                            }
                            results = new ArrayList<Map<String, String>>();
                            try (ResultSet rs = stmt.getResultSet();){
                                ResultSetMetaData metaData = rs.getMetaData();
                                while (rs.next() && (maxRows < 0 || results.size() < maxRows)) {
                                    LinkedHashMap<String, String> record = new LinkedHashMap<String, String>();
                                    for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                                        String value = rs.getString(i);
                                        value = rs.wasNull() ? this.getMessageSourceAccessor().getMessage("probe.src.dataSourceTest.sql.null") : HtmlUtils.htmlEscape((String)value);
                                        if (value.isEmpty()) {
                                            value = "&nbsp;";
                                        }
                                        StringBuilder key = new StringBuilder(metaData.getColumnLabel(i));
                                        while (record.containsKey(key.toString())) {
                                            key.append(" ");
                                        }
                                        record.put(HtmlUtils.htmlEscape((String)key.toString()), value);
                                    }
                                    results.add(record);
                                }
                            }
                            rowsAffected = results.size();
                        }
                    }
                    finally {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                }
                conn = sess;
                synchronized (conn) {
                    sessData.setResults(results);
                }
                ModelAndView mv = new ModelAndView(this.getViewName(), "results", results);
                mv.addObject("rowsAffected", (Object)String.valueOf(rowsAffected));
                mv.addObject("rowsPerPage", (Object)String.valueOf(rowsPerPage));
                return mv;
            }
            catch (SQLException e) {
                String message = this.getMessageSourceAccessor().getMessage("probe.src.dataSourceTest.sql.failure", new Object[]{e.getMessage()});
                logger.error(message, (Throwable)e);
                request.setAttribute("errorMessage", (Object)message);
            }
        }
        return new ModelAndView(this.getViewName());
    }

    @Override
    protected boolean isContextOptional() {
        return true;
    }

    @Override
    @Value(value="ajax/sql/recordset")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

