/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.sql;

import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.PostParameterizableViewController;
import psiprobe.model.sql.DataSourceTestInfo;

@Controller
public class CachedRecordSetController
extends PostParameterizableViewController {
    private static final Logger logger = LoggerFactory.getLogger(CachedRecordSetController.class);

    @RequestMapping(path={"/sql/cachedRecordset.ajax"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int rowsPerPage = ServletRequestUtils.getIntParameter((ServletRequest)request, (String)"rowsPerPage", (int)0);
        List<Map<String, String>> results = null;
        int rowsAffected = 0;
        HttpSession sess = request.getSession(false);
        if (sess == null) {
            request.setAttribute("errorMessage", (Object)this.getMessageSourceAccessor().getMessage("probe.src.dataSourceTest.cachedResultSet.failure"));
            logger.error("Cannot retrieve a cached result set. Http session is NULL.");
        } else {
            DataSourceTestInfo sessData = (DataSourceTestInfo)sess.getAttribute("dataSourceTestData");
            if (sessData == null) {
                request.setAttribute("errorMessage", (Object)this.getMessageSourceAccessor().getMessage("probe.src.dataSourceTest.cachedResultSet.failure"));
                logger.error("Cannot retrieve a cached result set. {} session attribute is NULL.", (Object)"dataSourceTestData");
            } else {
                HttpSession httpSession = sess;
                synchronized (httpSession) {
                    sessData.setRowsPerPage(rowsPerPage);
                }
                results = sessData.getResults();
                if (results == null) {
                    request.setAttribute("errorMessage", (Object)this.getMessageSourceAccessor().getMessage("probe.src.dataSourceTest.cachedResultSet.failure"));
                    logger.error("Cached results set is NULL.");
                } else {
                    rowsAffected = results.size();
                }
            }
        }
        ModelAndView mv = new ModelAndView(this.getViewName(), "results", results);
        mv.addObject("rowsAffected", (Object)String.valueOf(rowsAffected));
        mv.addObject("rowsPerPage", (Object)String.valueOf(rowsPerPage));
        return mv;
    }

    @Value(value="ajax/sql/recordset")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

