/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.sessions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Session;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.controllers.AbstractContextHandlerController;
import psiprobe.model.ApplicationSession;
import psiprobe.model.Attribute;
import psiprobe.model.SessionSearchInfo;
import psiprobe.tools.ApplicationUtils;
import psiprobe.tools.SecurityUtils;

@Controller
public class ListSessionsController
extends AbstractContextHandlerController {
    @RequestMapping(path={"/sessions.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ModelAndView handleContext(String contextName, Context context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<Object> ctxs;
        boolean calcSize = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"size", (boolean)false) && SecurityUtils.hasAttributeValueRole(this.getServletContext(), request);
        SessionSearchInfo searchInfo = new SessionSearchInfo();
        searchInfo.setSearchAction(StringUtils.trimToNull((String)ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"searchAction", (String)"none")));
        HttpSession sess = request.getSession(false);
        if (searchInfo.isApply()) {
            searchInfo.setSessionId(StringUtils.trimToNull((String)ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"searchSessionId")));
            searchInfo.setLastIp(StringUtils.trimToNull((String)ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"searchLastIP")));
            searchInfo.setAgeFrom(StringUtils.trimToNull((String)ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"searchAgeFrom")));
            searchInfo.setAgeTo(StringUtils.trimToNull((String)ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"searchAgeTo")));
            searchInfo.setIdleTimeFrom(StringUtils.trimToNull((String)ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"searchIdleTimeFrom")));
            searchInfo.setIdleTimeTo(StringUtils.trimToNull((String)ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"searchIdleTimeTo")));
            searchInfo.setAttrName(StringUtils.trimToNull((String)ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"searchAttrName")));
            if (sess != null) {
                sess.setAttribute("sessionSearchInfo", (Object)searchInfo);
            }
        } else if (sess != null) {
            if (searchInfo.isClear()) {
                sess.removeAttribute("sessionSearchInfo");
            } else {
                SessionSearchInfo ss = (SessionSearchInfo)sess.getAttribute("sessionSearchInfo");
                if (ss != null) {
                    searchInfo = ss;
                }
            }
        }
        if (context == null) {
            ctxs = this.getContainerWrapper().getTomcatContainer().findContexts();
        } else {
            ctxs = new ArrayList();
            ctxs.add(context);
        }
        ArrayList<ApplicationSession> sessionList = new ArrayList<ApplicationSession>();
        for (Context context2 : ctxs) {
            Session[] sessions;
            if (context2 == null || context2.getManager() == null || searchInfo.isApply() && !searchInfo.isUseSearch()) continue;
            for (Session session : sessions = context2.getManager().findSessions()) {
                ApplicationSession appSession = ApplicationUtils.getApplicationSession(session, calcSize, searchInfo.isUseAttr());
                if (appSession == null || !this.matchSession(appSession, searchInfo)) continue;
                if (context2.getName() != null) {
                    appSession.setApplicationName(context2.getName().length() > 0 ? context2.getName() : "/");
                }
                sessionList.add(appSession);
            }
        }
        if (sessionList.isEmpty() && searchInfo.isApply()) {
            HttpSession httpSession = sess;
            synchronized (httpSession) {
                this.populateSearchMessages(searchInfo);
            }
        }
        ModelAndView modelAndView = new ModelAndView(this.getViewName(), "sessions", sessionList);
        modelAndView.addObject("searchInfo", (Object)searchInfo);
        return modelAndView;
    }

    private void populateSearchMessages(SessionSearchInfo searchInfo) {
        MessageSourceAccessor msa = this.getMessageSourceAccessor();
        searchInfo.getErrorMessages().clear();
        if (searchInfo.isEmpty()) {
            searchInfo.addErrorMessage(msa.getMessage("probe.src.sessions.search.empty"));
        } else if (searchInfo.isValid()) {
            searchInfo.setInfoMessage(msa.getMessage("probe.src.sessions.search.results.empty"));
        } else {
            if (!searchInfo.isSessionIdValid()) {
                searchInfo.addErrorMessage(msa.getMessage("probe.src.sessions.search.invalid.sessionId", new Object[]{searchInfo.getSessionIdMsg()}));
            }
            if (!searchInfo.isAttrNameValid()) {
                for (String message : searchInfo.getAttrNameMsgs()) {
                    searchInfo.addErrorMessage(msa.getMessage("probe.src.sessions.search.invalid.attrName", new Object[]{message}));
                }
            }
            if (!searchInfo.isAgeFromValid()) {
                searchInfo.addErrorMessage(msa.getMessage("probe.src.sessions.search.invalid.ageFrom"));
            }
            if (!searchInfo.isAgeToValid()) {
                searchInfo.addErrorMessage(msa.getMessage("probe.src.sessions.search.invalid.ageTo"));
            }
            if (!searchInfo.isIdleTimeFromValid()) {
                searchInfo.addErrorMessage(msa.getMessage("probe.src.sessions.search.invalid.idleTimeFrom"));
            }
            if (!searchInfo.isIdleTimeToValid()) {
                searchInfo.addErrorMessage(msa.getMessage("probe.src.sessions.search.invalid.idleTimeTo"));
            }
            if (searchInfo.getErrorMessages().isEmpty()) {
                searchInfo.addErrorMessage(msa.getMessage("probe.src.sessions.search.invalid"));
            }
        }
    }

    private boolean matchSession(ApplicationSession appSession, SessionSearchInfo searchInfo) {
        boolean sessionMatches = true;
        if (searchInfo.isUseSearch()) {
            if (searchInfo.isUseSessionId() && appSession.getId() != null) {
                sessionMatches = searchInfo.getSessionIdPattern().matcher(appSession.getId()).matches();
            }
            if (sessionMatches && searchInfo.isUseAgeFrom()) {
                boolean bl = sessionMatches = appSession.getAge() >= searchInfo.getAgeFromSec().longValue() * 1000L;
            }
            if (sessionMatches && searchInfo.isUseAgeTo()) {
                boolean bl = sessionMatches = appSession.getAge() <= searchInfo.getAgeToSec().longValue() * 1000L;
            }
            if (sessionMatches && searchInfo.isUseIdleTimeFrom()) {
                boolean bl = sessionMatches = appSession.getIdleTime() >= searchInfo.getIdleTimeFromSec().longValue() * 1000L;
            }
            if (sessionMatches && searchInfo.isUseIdleTimeTo()) {
                boolean bl = sessionMatches = appSession.getIdleTime() <= searchInfo.getIdleTimeToSec().longValue() * 1000L;
            }
            if (searchInfo.isUseLastIp() && appSession.getLastAccessedIp() != null) {
                sessionMatches = appSession.getLastAccessedIp().contains(searchInfo.getLastIp());
            }
            if (sessionMatches && searchInfo.isUseAttrName()) {
                boolean attrMatches = false;
                ArrayList<Pattern> namePatterns = new ArrayList<Pattern>();
                namePatterns.addAll(searchInfo.getAttrNamePatterns());
                for (Attribute attr : appSession.getAttributes()) {
                    String attrName = attr.getName();
                    if (attrName == null) continue;
                    Iterator it = namePatterns.iterator();
                    while (it.hasNext()) {
                        if (!((Pattern)it.next()).matcher(attrName).matches()) continue;
                        it.remove();
                    }
                    if (!namePatterns.isEmpty()) continue;
                    attrMatches = true;
                    break;
                }
                sessionMatches = attrMatches;
            }
        }
        return sessionMatches;
    }

    @Override
    protected boolean isContextOptional() {
        return true;
    }

    @Override
    @Value(value="sessions")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

