/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.sessions;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.controllers.AbstractContextHandlerController;
import psiprobe.model.ApplicationSession;
import psiprobe.tools.ApplicationUtils;
import psiprobe.tools.SecurityUtils;

@Controller
public class ListSessionAttributesController
extends AbstractContextHandlerController {
    @RequestMapping(path={"/attributes.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    @Override
    protected ModelAndView handleContext(String contextName, Context context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean privileged = SecurityUtils.hasAttributeValueRole(this.getServletContext(), request);
        boolean calcSize = privileged && ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"size", (boolean)false);
        String sid = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"sid");
        ApplicationSession appSession = ApplicationUtils.getApplicationSession(context.getManager().findSession(sid), calcSize, true);
        if (appSession != null) {
            appSession.setAllowedToViewValues(privileged);
            return new ModelAndView(this.getViewName(), "session", (Object)appSession);
        }
        return new ModelAndView(this.getViewName());
    }

    @Override
    @Value(value="attributes")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

