/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.quickcheck;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.beans.ContainerListenerBean;
import psiprobe.controllers.AbstractTomcatContainerController;
import psiprobe.model.ApplicationResource;
import psiprobe.model.DataSourceInfo;
import psiprobe.model.TomcatTestReport;

public class BaseTomcatAvailabilityController
extends AbstractTomcatContainerController {
    @Inject
    private ContainerListenerBean containerListenerBean;

    public ContainerListenerBean getContainerListenerBean() {
        return this.containerListenerBean;
    }

    public void setContainerListenerBean(ContainerListenerBean containerListenerBean) {
        this.containerListenerBean = containerListenerBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long start = System.currentTimeMillis();
        TomcatTestReport tomcatTestReport = new TomcatTestReport();
        tomcatTestReport.setDatasourceUsageScore(0);
        boolean allContextsAvailable = true;
        if (this.getContainerWrapper().getResourceResolver().supportsPrivateResources()) {
            for (Context appContext : this.getContainerWrapper().getTomcatContainer().findContexts()) {
                allContextsAvailable = allContextsAvailable && this.getContainerWrapper().getTomcatContainer().getAvailable(appContext);
                List<ApplicationResource> applicationResources = this.getContainerWrapper().getResourceResolver().getApplicationResources(appContext, this.getContainerWrapper());
                for (ApplicationResource appResource : applicationResources) {
                    DataSourceInfo dsi = appResource.getDataSourceInfo();
                    if (dsi == null || dsi.getBusyScore() <= tomcatTestReport.getDatasourceUsageScore()) continue;
                    tomcatTestReport.setContextName(appContext.getName());
                    tomcatTestReport.setDatasourceUsageScore(dsi.getBusyScore());
                    tomcatTestReport.setDataSourceName(appResource.getName());
                }
            }
            tomcatTestReport.setWebappAvailabilityTest(allContextsAvailable ? 1 : 2);
        } else {
            List<ApplicationResource> resources = this.getContainerWrapper().getResourceResolver().getApplicationResources();
            for (ApplicationResource resource : resources) {
                DataSourceInfo dsi = resource.getDataSourceInfo();
                if (dsi == null || dsi.getBusyScore() <= tomcatTestReport.getDatasourceUsageScore()) continue;
                tomcatTestReport.setDatasourceUsageScore(dsi.getBusyScore());
                tomcatTestReport.setDataSourceName(resource.getName());
            }
        }
        tomcatTestReport.setDatasourceTest(1);
        String word = "hello";
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            for (int count = 0x100000 / word.length(); count > 0; --count) {
                bos.write(word.getBytes(StandardCharsets.UTF_8));
            }
            tomcatTestReport.setMemoryTest(1);
        }
        catch (IOException e) {
            tomcatTestReport.setMemoryTest(2);
            this.logger.trace("", (Throwable)e);
        }
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        ArrayList<Object> files = new ArrayList<Object>();
        ArrayList<OutputStream> fileStreams = new ArrayList<OutputStream>();
        try {
            for (int fileCount = tomcatTestReport.getDefaultFileCount(); fileCount > 0; --fileCount) {
                File file = new File(tmpDir, "tctest_" + fileCount);
                try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                    files.add(file);
                    fileStreams.add(outputStream);
                    outputStream.write("this is a test".getBytes(StandardCharsets.UTF_8));
                    continue;
                }
            }
            tomcatTestReport.setFileTest(1);
        }
        catch (IOException e) {
            tomcatTestReport.setFileTest(2);
            this.logger.trace("", (Throwable)e);
        }
        finally {
            for (OutputStream outputStream : fileStreams) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    this.logger.trace("", (Throwable)e);
                }
            }
            for (File file : files) {
                Files.delete(file.toPath());
            }
        }
        tomcatTestReport.setTestDuration(System.currentTimeMillis() - start);
        long maxServiceTime = 0L;
        tomcatTestReport.setMaxServiceTime(maxServiceTime);
        return new ModelAndView(this.getViewName(), "testReport", (Object)tomcatTestReport);
    }
}

