/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.oshi;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import oshi.PlatformEnum;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.Display;
import oshi.hardware.GlobalMemory;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.LogicalVolumeGroup;
import oshi.hardware.NetworkIF;
import oshi.hardware.PhysicalMemory;
import oshi.hardware.PowerSource;
import oshi.hardware.Sensors;
import oshi.hardware.SoundCard;
import oshi.hardware.UsbDevice;
import oshi.hardware.VirtualMemory;
import oshi.software.os.FileSystem;
import oshi.software.os.InternetProtocolStats;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSFileStore;
import oshi.software.os.OSProcess;
import oshi.software.os.OSService;
import oshi.software.os.OSSession;
import oshi.software.os.OperatingSystem;
import oshi.util.FormatUtil;
import oshi.util.Util;
import psiprobe.controllers.AbstractTomcatContainerController;

@Controller
public class OshiController
extends AbstractTomcatContainerController {
    private static final Logger logger = LoggerFactory.getLogger(OshiController.class);
    private static List<String> oshi = new ArrayList<String>();

    @RequestMapping(path={"/adm/oshi.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!oshi.isEmpty()) {
            ModelAndView mv = new ModelAndView(this.getViewName());
            mv.addObject("oshi", oshi);
            return mv;
        }
        oshi.add("Oshi results are performed as a system dump to screen here using Oshi SystemInfoTest logic.");
        oshi.add("Please be advised this is experimental in use and is slow. Resulting data is entirely cached.");
        oshi.add("Issues with library should be directed to https://github.com/oshi/oshi");
        oshi.add("For issues with our library usage of Oshi, please submit pull requests");
        oshi.add("");
        oshi.add("");
        this.initialize();
        ModelAndView mv = new ModelAndView(this.getViewName());
        mv.addObject("oshi", oshi);
        return mv;
    }

    @Override
    @Value(value="oshi")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }

    private void initialize() {
        logger.debug("Initializing System...");
        SystemInfo si = new SystemInfo();
        if (PlatformEnum.UNKNOWN.equals((Object)SystemInfo.getCurrentPlatform())) {
            logger.error("Oshi not supported on current platform");
            oshi.add("Oshi not supported on current platform");
            oshi.add("");
            return;
        }
        HardwareAbstractionLayer hal = si.getHardware();
        OperatingSystem os = si.getOperatingSystem();
        OshiController.printOperatingSystem(os);
        logger.debug("Checking computer system...");
        OshiController.printComputerSystem(hal.getComputerSystem());
        logger.debug("Checking Processor...");
        OshiController.printProcessor(hal.getProcessor());
        logger.debug("Checking Memory...");
        OshiController.printMemory(hal.getMemory());
        logger.debug("Checking CPU...");
        OshiController.printCpu(hal.getProcessor());
        logger.debug("Checking Processes...");
        OshiController.printProcesses(os, hal.getMemory());
        logger.debug("Checking Services...");
        OshiController.printServices(os);
        logger.debug("Checking Sensors...");
        OshiController.printSensors(hal.getSensors());
        logger.debug("Checking Power sources...");
        OshiController.printPowerSources(hal.getPowerSources());
        logger.debug("Checking Disks...");
        OshiController.printDisks(hal.getDiskStores());
        logger.debug("Checking Logical Volume Groups ...");
        OshiController.printLVgroups(hal.getLogicalVolumeGroups());
        logger.debug("Checking File System...");
        OshiController.printFileSystem(os.getFileSystem());
        logger.debug("Checking Network interfaces...");
        OshiController.printNetworkInterfaces(hal.getNetworkIFs());
        logger.debug("Checking Network parameters...");
        OshiController.printNetworkParameters(os.getNetworkParams());
        logger.debug("Checking IP statistics...");
        OshiController.printInternetProtocolStats(os.getInternetProtocolStats());
        logger.debug("Checking Displays...");
        OshiController.printDisplays(hal.getDisplays());
        logger.debug("Checking USB Devices...");
        OshiController.printUsbDevices(hal.getUsbDevices(true));
        logger.debug("Checking Sound Cards...");
        OshiController.printSoundCards(hal.getSoundCards());
        logger.debug("Checking Graphics Cards...");
        OshiController.printGraphicsCards(hal.getGraphicsCards());
        oshi.add("Finished Operating System and Hardware Info Dump");
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < oshi.size(); ++i) {
            output.append(oshi.get(i));
            if (oshi.get(i) == null || oshi.get(i).equals("\n")) continue;
            output.append('\n');
        }
        logger.info("Printing Operating System and Hardware Info:{}{}", (Object)Character.valueOf('\n'), (Object)output);
    }

    private static void printOperatingSystem(OperatingSystem operatingSystem) {
        oshi.add(String.valueOf(operatingSystem));
        oshi.add("Booted: " + Instant.ofEpochSecond(operatingSystem.getSystemBootTime()));
        oshi.add("Uptime: " + FormatUtil.formatElapsedSecs((long)operatingSystem.getSystemUptime()));
        oshi.add("Running with" + (operatingSystem.isElevated() ? "" : "out") + " elevated permissions.");
        oshi.add("Sessions:");
        for (OSSession s : operatingSystem.getSessions()) {
            oshi.add(" " + s.toString());
        }
    }

    private static void printComputerSystem(ComputerSystem computerSystem) {
        oshi.add("System: " + computerSystem.toString());
        oshi.add(" Firmware: " + computerSystem.getFirmware().toString());
        oshi.add(" Baseboard: " + computerSystem.getBaseboard().toString());
    }

    private static void printProcessor(CentralProcessor processor) {
        oshi.add(processor.toString());
        oshi.add(" Cores:");
        for (CentralProcessor.PhysicalProcessor p : processor.getPhysicalProcessors()) {
            oshi.add("  " + (processor.getPhysicalPackageCount() > 1 ? p.getPhysicalPackageNumber() + "," : "") + p.getPhysicalProcessorNumber() + ": efficiency=" + p.getEfficiency() + ", id=" + p.getIdString());
        }
    }

    private static void printMemory(GlobalMemory memory) {
        oshi.add("Physical Memory: \n " + memory.toString());
        VirtualMemory vm = memory.getVirtualMemory();
        oshi.add("Virtual Memory: \n " + vm.toString());
        List pmList = memory.getPhysicalMemory();
        if (!pmList.isEmpty()) {
            oshi.add("Physical Memory: ");
            for (PhysicalMemory pm : pmList) {
                oshi.add(" " + pm.toString());
            }
        }
    }

    private static void printCpu(CentralProcessor processor) {
        long[] freqs;
        double[] load;
        oshi.add("Context Switches/Interrupts: " + processor.getContextSwitches() + " / " + processor.getInterrupts());
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        long[][] prevProcTicks = processor.getProcessorCpuLoadTicks();
        oshi.add("CPU, IOWait, and IRQ ticks @ 0 sec:" + Arrays.toString(prevTicks));
        Util.sleep((long)1000L);
        long[] ticks = processor.getSystemCpuLoadTicks();
        oshi.add("CPU, IOWait, and IRQ ticks @ 1 sec:" + Arrays.toString(ticks));
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long sys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long totalCpu = user + nice + sys + idle + iowait + irq + softirq + steal;
        oshi.add(String.format("User: %.1f%% Nice: %.1f%% System: %.1f%% Idle: %.1f%% IOwait: %.1f%% IRQ: %.1f%% SoftIRQ: %.1f%% Steal: %.1f%%", 100.0 * (double)user / (double)totalCpu, 100.0 * (double)nice / (double)totalCpu, 100.0 * (double)sys / (double)totalCpu, 100.0 * (double)idle / (double)totalCpu, 100.0 * (double)iowait / (double)totalCpu, 100.0 * (double)irq / (double)totalCpu, 100.0 * (double)softirq / (double)totalCpu, 100.0 * (double)steal / (double)totalCpu));
        oshi.add(String.format("CPU load: %.1f%%", processor.getSystemCpuLoadBetweenTicks(prevTicks) * 100.0));
        double[] loadAverage = processor.getSystemLoadAverage(3);
        oshi.add("CPU load averages:" + (loadAverage[0] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[0])) + (loadAverage[1] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[1])) + (loadAverage[2] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[2])));
        StringBuilder procCpu = new StringBuilder("CPU load per processor:");
        for (double avg : load = processor.getProcessorCpuLoadBetweenTicks(prevProcTicks)) {
            procCpu.append(String.format(" %.1f%%", avg * 100.0));
        }
        oshi.add(procCpu.toString());
        long freq = processor.getProcessorIdentifier().getVendorFreq();
        if (freq > 0L) {
            oshi.add("Vendor Frequency: " + FormatUtil.formatHertz((long)freq));
        }
        if ((freq = processor.getMaxFreq()) > 0L) {
            oshi.add("Max Frequency: " + FormatUtil.formatHertz((long)freq));
        }
        if ((freqs = processor.getCurrentFreq())[0] > 0L) {
            StringBuilder sb = new StringBuilder("Current Frequencies: ");
            for (int i = 0; i < freqs.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(FormatUtil.formatHertz((long)freqs[i]));
            }
            oshi.add(sb.toString());
        }
    }

    private static void printProcesses(OperatingSystem os, GlobalMemory memory) {
        OSProcess myProc = os.getProcess(os.getProcessId());
        oshi.add("My PID: " + myProc.getProcessID() + " with affinity " + Long.toBinaryString(myProc.getAffinityMask()));
        oshi.add("Processes: " + os.getProcessCount() + ", Threads: " + os.getThreadCount());
        List procs = os.getProcesses(OperatingSystem.ProcessFiltering.ALL_PROCESSES, OperatingSystem.ProcessSorting.CPU_DESC, 5);
        oshi.add("   PID  %CPU %MEM       VSZ       RSS Name");
        for (int i = 0; i < procs.size() && i < 5; ++i) {
            OSProcess p = (OSProcess)procs.get(i);
            oshi.add(String.format(" %5d %5.1f %4.1f %9s %9s %s", p.getProcessID(), 100.0 * (double)(p.getKernelTime() + p.getUserTime()) / (double)p.getUpTime(), 100.0 * (double)p.getResidentSetSize() / (double)memory.getTotal(), FormatUtil.formatBytes((long)p.getVirtualSize()), FormatUtil.formatBytes((long)p.getResidentSetSize()), p.getName()));
        }
        OSProcess p = os.getProcess(os.getProcessId());
        oshi.add("Current process arguments: ");
        for (String string : p.getArguments()) {
            oshi.add("  " + string);
        }
        oshi.add("Current process environment: ");
        for (Map.Entry entry : p.getEnvironmentVariables().entrySet()) {
            oshi.add("  " + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
    }

    private static void printServices(OperatingSystem os) {
        oshi.add("Services: ");
        oshi.add("   PID   State   Name");
        int i = 0;
        for (OSService s : os.getServices()) {
            if (!s.getState().equals((Object)OSService.State.RUNNING) || i++ >= 5) continue;
            oshi.add(String.format(" %5d  %7s  %s", s.getProcessID(), s.getState(), s.getName()));
        }
        i = 0;
        for (OSService s : os.getServices()) {
            if (!s.getState().equals((Object)OSService.State.STOPPED) || i++ >= 5) continue;
            oshi.add(String.format(" %5d  %7s  %s", s.getProcessID(), s.getState(), s.getName()));
        }
    }

    private static void printSensors(Sensors sensors) {
        oshi.add("Sensors: " + sensors.toString());
    }

    private static void printPowerSources(List<PowerSource> list) {
        StringBuilder sb = new StringBuilder("Power Sources: ");
        if (list.isEmpty()) {
            sb.append("Unknown");
        }
        for (PowerSource powerSource : list) {
            sb.append("\n ").append(powerSource.toString());
        }
        oshi.add(sb.toString());
    }

    private static void printDisks(List<HWDiskStore> list) {
        oshi.add("Disks:");
        for (HWDiskStore disk : list) {
            oshi.add(" " + disk.toString());
            List partitions = disk.getPartitions();
            for (HWPartition part : partitions) {
                oshi.add(" |-- " + part.toString());
            }
        }
    }

    private static void printLVgroups(List<LogicalVolumeGroup> list) {
        if (!list.isEmpty()) {
            oshi.add("Logical Volume Groups:");
            for (LogicalVolumeGroup lvg : list) {
                oshi.add(" " + lvg.toString());
            }
        }
    }

    private static void printFileSystem(FileSystem fileSystem) {
        oshi.add("File System:");
        oshi.add(String.format(" File Descriptors: %d/%d", fileSystem.getOpenFileDescriptors(), fileSystem.getMaxFileDescriptors()));
        for (OSFileStore fs : fileSystem.getFileStores()) {
            long usable = fs.getUsableSpace();
            long total = fs.getTotalSpace();
            oshi.add(String.format(" %s (%s) [%s] %s of %s free (%.1f%%), %s of %s files free (%.1f%%) is %s " + (fs.getLogicalVolume() != null && fs.getLogicalVolume().length() > 0 ? "[%s]" : "%s") + " and is mounted at %s", fs.getName(), fs.getDescription().isEmpty() ? "file system" : fs.getDescription(), fs.getType(), FormatUtil.formatBytes((long)usable), FormatUtil.formatBytes((long)fs.getTotalSpace()), 100.0 * (double)usable / (double)total, FormatUtil.formatValue((long)fs.getFreeInodes(), (String)""), FormatUtil.formatValue((long)fs.getTotalInodes(), (String)""), 100.0 * (double)fs.getFreeInodes() / (double)fs.getTotalInodes(), fs.getVolume(), fs.getLogicalVolume(), fs.getMount()));
        }
    }

    private static void printNetworkInterfaces(List<NetworkIF> list) {
        StringBuilder sb = new StringBuilder("Network Interfaces:");
        if (list.isEmpty()) {
            sb.append(" Unknown");
        } else {
            for (NetworkIF net : list) {
                sb.append("\n ").append(net.toString());
            }
        }
        oshi.add(sb.toString());
    }

    private static void printNetworkParameters(NetworkParams networkParams) {
        oshi.add("Network parameters:\n " + networkParams.toString());
    }

    private static void printInternetProtocolStats(InternetProtocolStats internetProtocolStats) {
        oshi.add("Internet Protocol statistics:");
        oshi.add(" TCPv4: " + internetProtocolStats.getTCPv4Stats());
        oshi.add(" TCPv6: " + internetProtocolStats.getTCPv6Stats());
        oshi.add(" UDPv4: " + internetProtocolStats.getUDPv4Stats());
        oshi.add(" UDPv6: " + internetProtocolStats.getUDPv6Stats());
    }

    private static void printDisplays(List<Display> list) {
        oshi.add("Displays:");
        int i = 0;
        for (Display display : list) {
            oshi.add(" Display " + i + ":");
            oshi.add(String.valueOf(display));
            ++i;
        }
    }

    private static void printUsbDevices(List<UsbDevice> list) {
        oshi.add("USB Devices:");
        for (UsbDevice usbDevice : list) {
            oshi.add(String.valueOf(usbDevice));
        }
    }

    private static void printSoundCards(List<SoundCard> list) {
        oshi.add("Sound Cards:");
        for (SoundCard card : list) {
            oshi.add(" " + String.valueOf(card));
        }
    }

    private static void printGraphicsCards(List<GraphicsCard> list) {
        oshi.add("Graphics Cards:");
        if (list.isEmpty()) {
            oshi.add(" None detected.");
        } else {
            for (GraphicsCard card : list) {
                oshi.add(" " + String.valueOf(card));
            }
        }
    }
}

