/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.logs;

import java.io.File;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.Utils;
import psiprobe.controllers.logs.AbstractLogHandlerController;
import psiprobe.tools.logging.LogDestination;

@Controller
public class DownloadLogController
extends AbstractLogHandlerController {
    private static final Logger logger = LoggerFactory.getLogger(DownloadLogController.class);

    @RequestMapping(path={"/download"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    @Override
    protected ModelAndView handleLogFile(HttpServletRequest request, HttpServletResponse response, LogDestination logDest) throws Exception {
        boolean compressed = "true".equals(ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"compressed"));
        File file = logDest.getFile();
        logger.info("Sending {}{} to {} ({})", new Object[]{file, compressed ? " compressed" : "", request.getRemoteAddr(), request.getRemoteUser()});
        if (compressed) {
            Utils.sendCompressedFile(response, file);
        } else {
            Utils.sendFile(request, response, file);
        }
        return null;
    }

    @Value(value="")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

