/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.jsp;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.jasper.EmbeddedServletOptions;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.Utils;
import psiprobe.controllers.AbstractContextHandlerController;

@Controller
public class ViewServletSourceController
extends AbstractContextHandlerController {
    @RequestMapping(path={"/app/viewservlet.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    @Override
    protected ModelAndView handleContext(String contextName, Context context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        File servletFile;
        String servletName;
        String jspName = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"source", null);
        ServletContext sctx = context.getServletContext();
        ServletConfig scfg = (ServletConfig)context.findChild("jsp");
        EmbeddedServletOptions opt = new EmbeddedServletOptions(scfg, sctx);
        String encoding = opt.getJavaEncoding();
        String content = null;
        if (jspName != null && (servletName = this.getContainerWrapper().getTomcatContainer().getServletFileNameForJsp(context, jspName)) != null && (servletFile = new File(servletName)).exists()) {
            try (InputStream fis = Files.newInputStream(servletFile.toPath(), new OpenOption[0]);){
                content = Utils.highlightStream(jspName, fis, "java", encoding);
            }
        }
        return new ModelAndView(this.getViewName(), "content", content);
    }

    @Override
    @Value(value="view_servlet_source")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

