/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.deploy;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileItemFactory;
import org.apache.tomcat.util.http.fileupload.FileUploadBase;
import org.apache.tomcat.util.http.fileupload.RequestContext;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItemFactory;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.apache.tomcat.util.http.fileupload.servlet.ServletRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.InternalResourceView;
import psiprobe.controllers.AbstractTomcatContainerController;
import psiprobe.model.jsp.Summary;

@Controller
public class UploadWarController
extends AbstractTomcatContainerController {
    private static final Logger logger = LoggerFactory.getLogger(UploadWarController.class);

    @RequestMapping(path={"/adm/war.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (FileUploadBase.isMultipartContent((RequestContext)new ServletRequestContext(request))) {
            File tmpWar = null;
            String contextName = null;
            boolean update = false;
            boolean compile = false;
            boolean discard = false;
            DiskFileItemFactory factory = new DiskFileItemFactory(1048000, new File(System.getProperty("java.io.tmpdir")));
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setSizeMax(-1L);
            upload.setHeaderEncoding(StandardCharsets.UTF_8.name());
            try {
                List fileItems = upload.parseRequest((RequestContext)new ServletRequestContext(request));
                for (FileItem fi : fileItems) {
                    if (!fi.isFormField()) {
                        if (fi.getName() == null || fi.getName().length() <= 0) continue;
                        tmpWar = new File(System.getProperty("java.io.tmpdir"), FilenameUtils.getName((String)fi.getName()));
                        fi.write(tmpWar);
                        continue;
                    }
                    if ("context".equals(fi.getFieldName())) {
                        contextName = fi.getString();
                        continue;
                    }
                    if ("update".equals(fi.getFieldName()) && "yes".equals(fi.getString())) {
                        update = true;
                        continue;
                    }
                    if ("compile".equals(fi.getFieldName()) && "yes".equals(fi.getString())) {
                        compile = true;
                        continue;
                    }
                    if (!"discard".equals(fi.getFieldName()) || !"yes".equals(fi.getString())) continue;
                    discard = true;
                }
            }
            catch (Exception e) {
                logger.error("Could not process file upload", (Throwable)e);
                request.setAttribute("errorMessage", (Object)this.getMessageSourceAccessor().getMessage("probe.src.deploy.war.uploadfailure", new Object[]{e.getMessage()}));
                if (tmpWar != null && tmpWar.exists() && !tmpWar.delete()) {
                    logger.error("Unable to delete temp war file");
                }
                tmpWar = null;
            }
            String errMsg = null;
            if (tmpWar != null) {
                block28: {
                    try {
                        if (tmpWar.getName().endsWith(".war")) {
                            if (contextName == null || contextName.length() == 0) {
                                String warFileName = tmpWar.getName().replaceAll("\\.war$", "");
                                contextName = "/" + warFileName;
                            }
                            String visibleContextName = "".equals(contextName = this.getContainerWrapper().getTomcatContainer().formatContextName(contextName)) ? "/" : contextName;
                            request.setAttribute("contextName", (Object)visibleContextName);
                            if (update && this.getContainerWrapper().getTomcatContainer().findContext(contextName) != null) {
                                logger.debug("updating {}: removing the old copy", (Object)contextName);
                                this.getContainerWrapper().getTomcatContainer().remove(contextName);
                            }
                            if (this.getContainerWrapper().getTomcatContainer().findContext(contextName) == null) {
                                String destWarFilename = this.getContainerWrapper().getTomcatContainer().formatContextFilename(contextName);
                                File destWar = new File(this.getContainerWrapper().getTomcatContainer().getAppBase(), destWarFilename + ".war");
                                FileUtils.moveFile((File)tmpWar, (File)destWar);
                                this.getContainerWrapper().getTomcatContainer().installWar(contextName, new URL("jar:" + destWar.toURI().toURL() + "!/"));
                                Context ctx = this.getContainerWrapper().getTomcatContainer().findContext(contextName);
                                if (ctx == null) {
                                    errMsg = this.getMessageSourceAccessor().getMessage("probe.src.deploy.war.notinstalled", new Object[]{visibleContextName});
                                } else {
                                    request.setAttribute("success", (Object)Boolean.TRUE);
                                    Authentication auth = SecurityContextHolder.getContext().getAuthentication();
                                    String name = auth.getName();
                                    logger.info(this.getMessageSourceAccessor().getMessage("probe.src.log.deploywar"), (Object)name, (Object)contextName);
                                    if (discard) {
                                        this.getContainerWrapper().getTomcatContainer().discardWorkDir(ctx);
                                        logger.info(this.getMessageSourceAccessor().getMessage("probe.src.log.discardwork"), (Object)name, (Object)contextName);
                                    }
                                    if (compile) {
                                        Summary summary = new Summary();
                                        summary.setName(ctx.getName());
                                        this.getContainerWrapper().getTomcatContainer().listContextJsps(ctx, summary, true);
                                        request.getSession(false).setAttribute("jsp.summary", (Object)summary);
                                        request.setAttribute("compileSuccess", (Object)Boolean.TRUE);
                                    }
                                }
                            } else {
                                errMsg = this.getMessageSourceAccessor().getMessage("probe.src.deploy.war.alreadyExists", new Object[]{visibleContextName});
                            }
                        } else {
                            errMsg = this.getMessageSourceAccessor().getMessage("probe.src.deploy.war.notWar.failure");
                        }
                        if (errMsg == null) break block28;
                    }
                    catch (IOException e) {
                        block29: {
                            try {
                                errMsg = this.getMessageSourceAccessor().getMessage("probe.src.deploy.war.failure", new Object[]{e.getMessage()});
                                logger.error("Tomcat throw an exception when trying to deploy", (Throwable)e);
                                if (errMsg == null) break block29;
                            }
                            catch (Throwable throwable) {
                                if (errMsg != null) {
                                    request.setAttribute("errorMessage", errMsg);
                                }
                                if (tmpWar.exists() && !tmpWar.delete()) {
                                    logger.error("Unable to delete temp war file");
                                }
                                throw throwable;
                            }
                            request.setAttribute("errorMessage", (Object)errMsg);
                        }
                        if (tmpWar.exists() && !tmpWar.delete()) {
                            logger.error("Unable to delete temp war file");
                        }
                    }
                    request.setAttribute("errorMessage", (Object)errMsg);
                }
                if (tmpWar.exists() && !tmpWar.delete()) {
                    logger.error("Unable to delete temp war file");
                }
            }
        }
        return new ModelAndView((View)new InternalResourceView(this.getViewName()));
    }

    @Override
    @Value(value="/adm/deploy.htm")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

