/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.deploy;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.InternalResourceView;
import org.springframework.web.servlet.view.RedirectView;
import psiprobe.controllers.AbstractContextHandlerController;

public class BaseUndeployContextController
extends AbstractContextHandlerController {
    private static final Logger logger = LoggerFactory.getLogger(BaseUndeployContextController.class);
    private String failureViewName;

    public String getFailureViewName() {
        return this.failureViewName;
    }

    public void setFailureViewName(String failureViewName) {
        this.failureViewName = failureViewName;
    }

    @Override
    protected ModelAndView handleContext(String contextName, Context context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            if (request.getContextPath().equals(contextName)) {
                throw new IllegalStateException(this.getMessageSourceAccessor().getMessage("probe.src.contextAction.cannotActOnSelf"));
            }
            this.getContainerWrapper().getTomcatContainer().remove(contextName);
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            String name = auth.getName();
            logger.info(this.getMessageSourceAccessor().getMessage("probe.src.log.undeploy"), (Object)name, (Object)contextName);
        }
        catch (Exception e) {
            request.setAttribute("errorMessage", (Object)e.getMessage());
            logger.error("Error during undeploy of '{}'", (Object)contextName, (Object)e);
            return new ModelAndView((View)new InternalResourceView(this.getFailureViewName() == null ? this.getViewName() : this.getFailureViewName()));
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + this.getViewName()));
    }

    protected void executeAction(String contextName) throws Exception {
    }
}

