/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.connectors;

import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.ParameterizableViewController;
import org.springframework.web.servlet.view.RedirectView;
import psiprobe.beans.ContainerListenerBean;
import psiprobe.beans.stats.collectors.ConnectorStatsCollectorBean;

@Controller
public class ToggleConnectorStatusController
extends ParameterizableViewController {
    private static final Logger logger = LoggerFactory.getLogger(ToggleConnectorStatusController.class);
    @Inject
    private ConnectorStatsCollectorBean collectorBean;
    @Inject
    private ContainerListenerBean containerListener;

    public ConnectorStatsCollectorBean getCollectorBean() {
        return this.collectorBean;
    }

    public void setCollectorBean(ConnectorStatsCollectorBean collectorBean) {
        this.collectorBean = collectorBean;
    }

    @RequestMapping(path={"/app/connectorStatus.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String connectorName = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)"cn");
        String port = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)"port");
        String operation = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)"operation");
        this.containerListener.toggleConnectorStatus(operation, port);
        logger.info("Connector status toggled for {}", (Object)connectorName);
        return new ModelAndView((View)new RedirectView(request.getContextPath() + this.getViewName()));
    }

    @Value(value="/connectors.htm")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

