/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.connectors;

import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.beans.ContainerListenerBean;
import psiprobe.controllers.AbstractTomcatContainerController;
import psiprobe.model.Connector;
import psiprobe.model.RequestProcessor;
import psiprobe.tools.TimeExpression;

@Controller
public class ListConnectorsController
extends AbstractTomcatContainerController {
    @Inject
    private ContainerListenerBean containerListenerBean;
    private boolean includeRequestProcessors;
    private long collectionPeriod;

    public ContainerListenerBean getContainerListenerBean() {
        return this.containerListenerBean;
    }

    public void setContainerListenerBean(ContainerListenerBean containerListenerBean) {
        this.containerListenerBean = containerListenerBean;
    }

    public long getCollectionPeriod() {
        return this.collectionPeriod;
    }

    public void setCollectionPeriod(long collectionPeriod) {
        this.collectionPeriod = collectionPeriod;
    }

    @Value(value="${psiprobe.beans.stats.collectors.connector.period}")
    public void setCollectionPeriod(String collectionPeriod) {
        this.collectionPeriod = TimeExpression.inSeconds(collectionPeriod);
    }

    public boolean isIncludeRequestProcessors() {
        return this.includeRequestProcessors;
    }

    @Value(value="true")
    public void setIncludeRequestProcessors(boolean includeRequestProcessors) {
        this.includeRequestProcessors = includeRequestProcessors;
    }

    @RequestMapping(path={"/connectors.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<RequestProcessor> reqProcs;
        boolean workerThreadNameSupported = false;
        List<Connector> connectors = this.containerListenerBean.getConnectors(this.includeRequestProcessors);
        if (!connectors.isEmpty() && !(reqProcs = connectors.get(0).getRequestProcessors()).isEmpty()) {
            RequestProcessor reqProc = reqProcs.get(0);
            workerThreadNameSupported = reqProc.isWorkerThreadNameSupported();
        }
        return new ModelAndView(this.getViewName()).addObject("connectors", connectors).addObject("workerThreadNameSupported", (Object)workerThreadNameSupported).addObject("collectionPeriod", (Object)this.getCollectionPeriod());
    }

    @Override
    @Value(value="connectors")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

