/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.certificates;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Connector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.controllers.AbstractTomcatContainerController;
import psiprobe.controllers.certificates.SslHostConfigHelper;
import psiprobe.model.certificates.Cert;
import psiprobe.model.certificates.CertificateInfo;
import psiprobe.model.certificates.ConnectorInfo;
import psiprobe.model.certificates.OldConnectorInfo;
import psiprobe.model.certificates.SslHostConfigInfo;

@Controller
public class ListCertificatesController
extends AbstractTomcatContainerController {
    private static final Logger logger = LoggerFactory.getLogger(ListCertificatesController.class);

    @RequestMapping(path={"/certificates.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView(this.getViewName());
        try {
            List<Connector> connectors = this.getContainerWrapper().getTomcatContainer().findConnectors();
            List<ConnectorInfo> infos = this.getConnectorInfos(connectors);
            for (ConnectorInfo info : infos) {
                List<SslHostConfigInfo> sslHostConfigInfos = info.getSslHostConfigInfos();
                for (SslHostConfigInfo sslHostConfigInfo : sslHostConfigInfos) {
                    List<Cert> certs;
                    if (sslHostConfigInfo.getTruststoreFile() != null) {
                        certs = this.getCertificates(sslHostConfigInfo.getTruststoreType(), sslHostConfigInfo.getTruststoreFile(), sslHostConfigInfo.getTruststorePassword());
                        sslHostConfigInfo.setTrustStoreCerts(certs);
                    }
                    List<CertificateInfo> certificateInfos = sslHostConfigInfo.getCertificateInfos();
                    for (CertificateInfo certificateInfo : certificateInfos) {
                        if (certificateInfo.getCertificateKeystoreFile() == null) continue;
                        certs = this.getCertificates(certificateInfo.getCertificateKeystoreType(), certificateInfo.getCertificateKeystoreFile(), certificateInfo.getCertificateKeystorePassword());
                        certificateInfo.setKeyStoreCerts(certs);
                    }
                }
            }
            modelAndView.addObject("connectors", infos);
        }
        catch (Exception e) {
            logger.error("There was an exception listing certificates", (Throwable)e);
        }
        return modelAndView;
    }

    public List<Cert> getCertificates(String storeType, String storeFile, String storePassword) throws Exception {
        KeyStore keyStore = storeType != null ? KeyStore.getInstance(storeType) : KeyStore.getInstance(KeyStore.getDefaultType());
        char[] password = null;
        if (storePassword != null) {
            password = storePassword.toCharArray();
        }
        try (InputStream storeInput = this.getStoreInputStream(storeFile);){
            keyStore.load(storeInput, password);
        }
        catch (IOException e) {
            logger.error("Error loading store file {}", (Object)storeFile, (Object)e);
            return null;
        }
        ArrayList<Cert> certs = new ArrayList<Cert>();
        for (String alias : Collections.list(keyStore.aliases())) {
            Certificate[] certificateChains = keyStore.getCertificateChain(alias);
            if (certificateChains != null) {
                for (Certificate certificateChain : certificateChains) {
                    X509Certificate x509Cert = (X509Certificate)certificateChain;
                    this.addToStore(certs, alias, x509Cert);
                }
                continue;
            }
            X509Certificate x509Cert = (X509Certificate)keyStore.getCertificate(alias);
            this.addToStore(certs, alias, x509Cert);
        }
        return certs;
    }

    private List<ConnectorInfo> getConnectorInfos(List<Connector> connectors) throws IllegalAccessException, InvocationTargetException {
        ArrayList<ConnectorInfo> infos = new ArrayList<ConnectorInfo>();
        for (Connector connector : connectors) {
            AbstractHttp11JsseProtocol protocol;
            ProtocolHandler protocolHandler;
            if (!connector.getSecure() || !((protocolHandler = connector.getProtocolHandler()) instanceof AbstractHttp11JsseProtocol) || !(protocol = (AbstractHttp11JsseProtocol)protocolHandler).getSecure()) continue;
            infos.add(this.toConnectorInfo(protocol));
        }
        return infos;
    }

    private InputStream getStoreInputStream(String path) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        File catalinaBaseFolder = new File(System.getProperty("catalina.base"));
        file = new File(catalinaBaseFolder, path);
        if (file.exists()) {
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        URI uri = catalinaBaseFolder.toURI().resolve(path);
        URL url = uri.toURL();
        return url.openConnection().getInputStream();
    }

    private ConnectorInfo toConnectorInfo(AbstractHttp11JsseProtocol<?> protocol) throws IllegalAccessException, InvocationTargetException {
        ConnectorInfo info = new ConnectorInfo();
        info.setName(ObjectName.unquote(protocol.getName()));
        try {
            Object defaultSslHostConfigName = MethodUtils.invokeMethod(protocol, (String)"getDefaultSSLHostConfigName");
            if (defaultSslHostConfigName == null) {
                logger.error("Cannot determine defaultSslHostConfigName");
                return info;
            }
            info.setDefaultSslHostConfigName(String.valueOf(defaultSslHostConfigName));
            new SslHostConfigHelper(protocol, info);
        }
        catch (NoSuchMethodException e) {
            logger.trace("", (Throwable)e);
            OldConnectorInfo oldConnectorInfo = new OldConnectorInfo();
            BeanUtils.copyProperties((Object)oldConnectorInfo, protocol);
            info.setDefaultSslHostConfigName("_default_");
            info.setSslHostConfigInfos(oldConnectorInfo.getSslHostConfigInfos());
        }
        return info;
    }

    private void addToStore(List<Cert> certs, String alias, X509Certificate x509Cert) {
        Cert cert = new Cert();
        cert.setAlias(alias);
        cert.setSubjectDistinguishedName(x509Cert.getSubjectDN().toString());
        cert.setNotBefore(x509Cert.getNotBefore());
        cert.setNotAfter(x509Cert.getNotAfter());
        cert.setIssuerDistinguishedName(x509Cert.getIssuerDN().toString());
        certs.add(cert);
    }

    @Override
    @Value(value="certificates")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

