/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.apps;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.controllers.AbstractTomcatContainerController;
import psiprobe.model.Application;
import psiprobe.tools.ApplicationUtils;
import psiprobe.tools.SecurityUtils;

@Controller
public class ListWebappsController
extends AbstractTomcatContainerController {
    @RequestMapping(path={"/index.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<Context> apps;
        boolean calcSize = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"size", (boolean)false) && SecurityUtils.hasAttributeValueRole(this.getServletContext(), request);
        try {
            apps = this.getContainerWrapper().getTomcatContainer().findContexts();
        }
        catch (NullPointerException ex) {
            throw new IllegalStateException("No container found for your server: " + this.getServletContext().getServerInfo(), ex);
        }
        ArrayList<Application> applications = new ArrayList<Application>(apps.size());
        boolean showResources = this.getContainerWrapper().getResourceResolver().supportsPrivateResources();
        for (Context appContext : apps) {
            if (appContext.getName() == null) continue;
            applications.add(ApplicationUtils.getApplication(appContext, this.getContainerWrapper().getResourceResolver(), calcSize, this.getContainerWrapper()));
        }
        if (!applications.isEmpty() && !showResources) {
            request.setAttribute("no_resources", (Object)Boolean.TRUE);
        }
        return new ModelAndView(this.getViewName(), "apps", applications);
    }

    @Override
    @Value(value="applications")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

